/*
 * Decompiled with CFR 0.152.
 */
package org.ploin.web.faces.validator;

import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ploin.web.faces.validator.NumberValidator;

public class NumberOnlyValidator
extends NumberValidator
implements Serializable {
    private static final long serialVersionUID = -6692886544747634947L;
    private Log log = LogFactory.getLog(NumberOnlyValidator.class);

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String val = this.getValue(value);
        Pattern p = Pattern.compile("[0-9]*");
        Matcher m = p.matcher(val);
        if (!m.matches()) {
            String message = null;
            try {
                String bundleName = context.getApplication().getMessageBundle();
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, this.getLocale());
                message = bundle.getString("ploin.numberOnlyValidator");
            }
            catch (Exception e) {
                this.log.error((Object)"ERROR in NumberOnlyValidator ", (Throwable)e);
            }
            if (message == null || message.equals("")) {
                message = "Validationerror. Please type in a just numbers!";
            }
            throw new ValidatorException(new FacesMessage(message));
        }
    }
}

