/*
 * Decompiled with CFR 0.152.
 */
package org.ploin.web.faces.validator;

import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ploin.web.faces.validator.PloinJsfValidator;

public class EmailValidator
extends PloinJsfValidator
implements Serializable {
    private static final long serialVersionUID = -5788761962473298350L;
    private Log log = LogFactory.getLog(EmailValidator.class);

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        Pattern p = Pattern.compile("[A-Za-z0-9._%+-]+@[A-Za-z0-9._%+-]+\\.[A-Za-z]{2,4}");
        Matcher m = p.matcher((String)value);
        if (!m.matches() || ((String)value).length() < 6) {
            String message = null;
            try {
                String bundleName = context.getApplication().getMessageBundle();
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, this.getLocale());
                message = bundle.getString("ploin.emailValidator");
            }
            catch (Exception e) {
                this.log.error((Object)"ERROR in EmailValidator ", (Throwable)e);
            }
            if (message == null || message.equals("")) {
                message = "Validationerror. Please type in a valid e-mail-adress!";
            }
            throw new ValidatorException(new FacesMessage(message));
        }
    }
}

