/*
 * Decompiled with CFR 0.152.
 */
package org.ploin.web.faces.phaselistener;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ploin.web.flow.Flow;
import org.ploin.web.flow.FlowControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfPhaseListener06
implements PhaseListener {
    private static final long serialVersionUID = -7082297612107349222L;
    private static Log log = LogFactory.getLog(JsfPhaseListener06.class);
    private FacesContext facesContextTest = null;
    private FlowControl flowControl = new FlowControl();

    public void beforePhase(PhaseEvent event) {
        List flows;
        Object object;
        log.info((Object)("beforePhase " + this.getPhaseId()));
        FacesContext facesContext = null;
        facesContext = this.facesContextTest != null ? this.facesContextTest : FacesContext.getCurrentInstance();
        HttpSession session = (HttpSession)facesContext.getExternalContext().getSession(true);
        session.setAttribute("jsfPhase", (Object)6);
        String fromViewId = (String)session.getAttribute("ploinFacesFromViewId");
        String toViewId = null;
        if (facesContext.getViewRoot() != null) {
            toViewId = facesContext.getViewRoot().getViewId();
        }
        if ((object = facesContext.getExternalContext().getApplicationMap().get("ploinFlows")) != null && object instanceof List && (flows = (List)object).size() > 0) {
            FlowControl flowControl = new FlowControl();
            for (Flow flow : flows) {
                if (!flowControl.isViewInSet(flow.getIgnoreViews(), toViewId)) {
                    if (!flowControl.isViewInSet(flow.getViews(), toViewId) || flow.getAuthoritySource() == null || flow.getExcludeAuthoritys().size() <= 0 && flow.getIncludeAuthoritys().size() <= 0) continue;
                    try {
                        String destViewId;
                        Object as = facesContext.getApplication().createValueBinding(flow.getAuthoritySource()).getValue(facesContext);
                        if (!(as instanceof String)) continue;
                        String authS = (String)as;
                        if ((flow.getIncludeAuthoritys().size() <= 0 || flow.includeContains(authS)) && (flow.getExcludeAuthoritys().size() <= 0 || !flow.excludeContains(authS))) continue;
                        ViewHandler handler = facesContext.getApplication().getViewHandler();
                        if (flow.getAccessDeniedPage() != null && !"".equalsIgnoreCase(flow.getAccessDeniedPage())) {
                            destViewId = flow.getAccessDeniedPage();
                            log.debug((Object)("Access denied for " + toViewId + "! go to the defined accessDeniedPage " + destViewId));
                        } else {
                            destViewId = fromViewId;
                            log.debug((Object)("Access denied for " + toViewId + "! There is no accessDeniedPage defined. Stay on " + destViewId));
                        }
                        UIViewRoot viewRoot = handler.createView(FacesContext.getCurrentInstance(), destViewId);
                        facesContext.setViewRoot(viewRoot);
                        facesContext.renderResponse();
                    }
                    catch (Exception e) {
                        log.error((Object)"error in beforePhase securityCode ", (Throwable)e);
                    }
                    continue;
                }
                log.debug((Object)(" view is in ignoreSet " + toViewId));
            }
        }
    }

    public void afterPhase(PhaseEvent event) {
        String fromViewId;
        log.info((Object)("afterPhase " + this.getPhaseId()));
        FacesContext facesContext = null;
        facesContext = this.facesContextTest != null ? this.facesContextTest : FacesContext.getCurrentInstance();
        HttpSession session = (HttpSession)facesContext.getExternalContext().getSession(true);
        session.removeAttribute("jsfPhase");
        session.removeAttribute("lifecycleId");
        Long time = (Long)session.getAttribute("ploinFacesTime");
        session.removeAttribute("ploinFacesTime");
        String toViewId = fromViewId = (String)session.getAttribute("ploinFacesFromViewId");
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            toViewId = facesContext.getViewRoot().getViewId();
        }
        session.setAttribute("ploinFacesFromViewId", (Object)toViewId);
        log.debug((Object)("go to viewId " + toViewId));
        Object object = facesContext.getExternalContext().getApplicationMap().get("ploinFlows");
        if (object == null || !(object instanceof List)) {
            this.logTime(time);
            return;
        }
        List flows = (List)object;
        if (flows.size() == 0) {
            this.logTime(time);
            return;
        }
        for (Flow flow : flows) {
            if (this.flowControl.isViewInSet(flow.getIgnoreViews(), toViewId)) {
                log.debug((Object)(" view is in ignoreSet " + toViewId));
                break;
            }
            if (this.flowControl.isStayInFlow(flow.getViews(), fromViewId, toViewId)) {
                this.stayInFlow(flow, facesContext);
                continue;
            }
            if (!this.flowControl.isLeavingFlow(flow.getViews(), fromViewId, toViewId)) continue;
            this.processLeavingFlow(facesContext, session, flows, flow, fromViewId, toViewId);
        }
        this.logTime(time);
    }

    public void logTime(Long time) {
        log.info((Object)".");
        if (time != null) {
            long t2 = System.currentTimeMillis();
            long t3 = t2 - time;
            log.info((Object)("from beforePhase1 to afterPhase6: " + t3 + "ms"));
        }
    }

    public Set<String> getFlowPath(HttpSession session) {
        HashSet flowPath = (HashSet)session.getAttribute("ploinFacesFlowPath");
        if (flowPath == null) {
            flowPath = new HashSet();
        }
        return flowPath;
    }

    public void stayInFlow(Flow flow, FacesContext fc) {
        log.debug((Object)("stay in flow with id: " + flow.getFlowId()));
        String action = flow.getAfterLifecycleAction();
        if (action != null) {
            log.debug((Object)(" execute afterLifecycleAction " + action));
            fc.getApplication().createValueBinding(action).getValue(fc);
        }
    }

    public void processLeavingFlow(FacesContext fc, HttpSession session, List<Flow> flows, Flow flow, String fromViewId, String toViewId) {
        Set<String> flowPath = this.getFlowPath(session);
        if (this.flowControl.isViewInSubFlows(flows, flow, toViewId)) {
            this.entrySubFlow(flowPath, flow, session);
        } else if (this.flowControl.isViewInFlowPath(flows, flowPath, toViewId)) {
            this.leaveSubFlowAndReturnToParentFlow(flows, flowPath, toViewId, flow, session, fc);
        } else {
            this.leaveFlow(flowPath, fc, session, flow, flows);
        }
    }

    private void entrySubFlow(Set<String> flowPath, Flow flow, HttpSession session) {
        log.debug((Object)"leaving flow and entry subFlow ");
        flowPath.add(flow.getFlowId());
        session.setAttribute("ploinFacesFlowPath", flowPath);
    }

    private void leaveSubFlowAndReturnToParentFlow(List<Flow> flows, Set<String> flowPath, String toViewId, Flow flow, HttpSession session, FacesContext fc) {
        String flowIdInFlowPath = this.flowControl.getFlowIdForViewInFlowPath(flows, flowPath, toViewId);
        log.debug((Object)("leaving flow with id: " + flow.getFlowId() + " and go back to parent flow: " + flowIdInFlowPath));
        this.flowControl.leaveFlow(flow, fc, session);
        flowPath.remove(flow.getFlowId());
        if (flowPath.size() == 0) {
            session.removeAttribute("ploinFacesFlowPath");
        } else {
            session.setAttribute("ploinFacesFlowPath", flowPath);
        }
    }

    private void leaveFlow(Set<String> flowPath, FacesContext fc, HttpSession session, Flow flow, List<Flow> flows) {
        this.flowControl.leaveFlow(flow, fc, session);
        log.debug((Object)("leaving flow: " + flow.getFlowId()));
        for (String flowId : flowPath) {
            Flow fl = this.flowControl.getFlowById(flowId, flows);
            this.flowControl.leaveFlow(fl, fc, session);
            log.debug((Object)(" - leaving subflow: " + flowId));
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public FacesContext getFacesContextTest() {
        return this.facesContextTest;
    }

    public void setFacesContextTest(FacesContext facesContextTest) {
        this.facesContextTest = facesContextTest;
    }
}

