/*
 * Decompiled with CFR 0.152.
 */
package org.ploin.web.faces;

import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ploin.web.faces.Base;

public class BaseMessages
extends Base {
    private static Log log = LogFactory.getLog(BaseMessages.class);
    private static String SHALE = "???";
    private String detailSuffix = "Detail";
    private String summarySuffix = "Suffix";

    public String getStringFromResourceBundle(String key) {
        return this.getStringFromResourceBundle(key, null);
    }

    public String getStringFromResourceBundle(String key, String[] params) {
        StringBuffer result = new StringBuffer();
        try {
            ResourceBundle resourceBundle = this.getResourceBundle();
            String value = resourceBundle.getString(key);
            value = this.replaceParamsInText(params, value);
            result.append(value);
        }
        catch (Exception e) {
            log.error((Object)("ERROR in getStringFromResourceBundle(String key, String[] params), key=" + key + ", params=" + params), (Throwable)e);
            result.append(SHALE);
            result.append(key);
            result.append(SHALE);
        }
        return result.toString();
    }

    public String getStringFromResourceBundleDetail(String key) {
        return this.getStringFromResourceBundleDetail(key, null);
    }

    public String getStringFromResourceBundleDetail(String key, String[] params) {
        key = this.getDetailKey(key);
        return this.getStringFromResourceBundle(key, params);
    }

    public String getStringFromResourceBundleSummary(String key) {
        return this.getStringFromResourceBundleSummary(key, null);
    }

    public String getStringFromResourceBundleSummary(String key, String[] params) {
        key = this.getSummaryKey(key);
        return this.getStringFromResourceBundle(key, params);
    }

    public void addHTMLMessageFromBundle(FacesMessage.Severity severity, String key) {
        this.addHTMLMessageFromBundle(null, severity, key);
    }

    public void addHTMLMessageFromBundle(String componentId, FacesMessage.Severity severity, String key) {
        this.addHTMLMessageFromBundle(componentId, severity, key, null);
    }

    public void addHTMLMessageFromBundle(FacesMessage.Severity severity, String key, String[] params) {
        this.addHTMLMessageFromBundle(null, severity, key, params);
    }

    public void addHTMLMessageFromBundle(String componentId, FacesMessage.Severity severity, String key, String[] params) {
        ResourceBundle resourceBundle = this.getResourceBundle();
        String summary = this.getStringFromResourceBundleSummary(key);
        String detail = this.getStringFromResourceBundleDetail(key, params);
        BaseMessages.getFacesContext().addMessage(componentId, new FacesMessage(severity, summary, detail));
    }

    public void addInfoMessage(String componentId, String key, String[] params) {
        this.addHTMLMessageFromBundle(componentId, FacesMessage.SEVERITY_INFO, key, params);
    }

    public void addInfoMessage(String key) {
        this.addHTMLMessageFromBundle(null, FacesMessage.SEVERITY_INFO, key, null);
    }

    public void addInfoMessageText(String text) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, text, text));
    }

    public void addInfoMessageText(String summary, String detail) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, summary, detail));
    }

    public void addWarnMessage(String componentId, String key, String[] params) {
        this.addHTMLMessageFromBundle(componentId, FacesMessage.SEVERITY_WARN, key, params);
    }

    public void addWarnMessage(String key) {
        this.addHTMLMessageFromBundle(null, FacesMessage.SEVERITY_WARN, key, null);
    }

    public void addWarnMessageText(String text) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, text, text));
    }

    public void addWarnMessageText(String summary, String detail) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, summary, detail));
    }

    public void addErrorMessage(String componentId, String key, String[] params) {
        this.addHTMLMessageFromBundle(componentId, FacesMessage.SEVERITY_ERROR, key, params);
    }

    public void addErrorMessage(String key) {
        this.addHTMLMessageFromBundle(FacesMessage.SEVERITY_ERROR, key);
    }

    public void addErrorMessageText(String text) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, text, text));
    }

    public void addErrorMessageText(String summary, String detail) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
    }

    public void addFatalMessage(String componentId, String key, String[] params) {
        this.addHTMLMessageFromBundle(componentId, FacesMessage.SEVERITY_FATAL, key, params);
    }

    public void addFatalMessage(String key) {
        this.addHTMLMessageFromBundle(FacesMessage.SEVERITY_FATAL, key);
    }

    public void addFatalMessageText(String text) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, text, text));
    }

    public void addFatalMessageText(String summary, String detail) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, summary, detail));
    }

    public void addHTMLMessage(FacesMessage.Severity severity, String summary, String detail) {
        BaseMessages.getFacesContext().addMessage(null, new FacesMessage(severity, summary, detail));
    }

    private String replaceParamsInText(String[] params, String text) {
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                text = text.replaceAll("\\{" + i + "\\}", params[i]);
            }
        }
        return text;
    }

    private String getDetailKey(String key) {
        return key + this.getDetailSuffix();
    }

    private String getSummaryKey(String key) {
        return key + this.getSummarySuffix();
    }

    public String getDetailSuffix() {
        return this.detailSuffix;
    }

    public void setDetailSuffix(String detailSuffix) {
        this.detailSuffix = detailSuffix;
    }

    public String getSummarySuffix() {
        return this.summarySuffix;
    }

    public void setSummarySuffix(String summarySuffix) {
        this.summarySuffix = summarySuffix;
    }
}

