/*
 * Decompiled with CFR 0.152.
 */
package org.ploin.web.faces;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ploin.web.faces.BaseMessages;
import org.ploin.web.flow.Flow;
import org.ploin.web.flow.FlowControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseBean
extends BaseMessages
implements Serializable {
    private static final long serialVersionUID = 1987654321L;
    private static Log log = LogFactory.getLog(BaseBean.class);
    private Lifecycle lifecycle = null;

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)BaseBean.getFacesContext().getExternalContext().getRequest();
        }
        catch (Exception e) {
            log.error((Object)"ERROR in getRequest, ", (Throwable)e);
        }
        return request;
    }

    public static HttpSession getSession() {
        HttpServletRequest request = BaseBean.getRequest();
        if (request != null) {
            HttpSession session = request.getSession();
            return session;
        }
        return null;
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = null;
        try {
            response = (HttpServletResponse)BaseBean.getFacesContext().getExternalContext().getResponse();
        }
        catch (Exception e) {
            log.error((Object)"ERROR in getResponse, ", (Throwable)e);
        }
        return response;
    }

    public static Map getApplicationMap() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getExternalContext().getApplicationMap();
    }

    public static Object getValueFromApplicationMap(Object key) {
        return BaseBean.getApplicationMap().get(key);
    }

    public static Map<String, String> getRequestMap() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getExternalContext().getRequestParameterMap();
    }

    protected Long getLongFromRequestMap(String key) {
        if (key == null || "".equals(key.trim())) {
            return null;
        }
        try {
            String value = BaseBean.getRequestMap().get(key);
            if (value == null || "".equals(value) || "null".equals(value)) {
                return null;
            }
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.error((Object)"ERROR in getLongFromRequestMap, key not found ", (Throwable)e);
            return null;
        }
    }

    protected Integer getIntegerFromRequestMap(String key) {
        if (key == null || "".equals(key.trim())) {
            return null;
        }
        try {
            String value = BaseBean.getRequestMap().get(key);
            if (value == null || "".equals(value) || "null".equals(value)) {
                return null;
            }
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.error((Object)"ERROR in getIntegerFromRequestMap, key not found ", (Throwable)e);
            return null;
        }
    }

    protected String getStringFromRequestMap(String key) {
        if (key == null || "".equals(key.trim())) {
            return null;
        }
        try {
            String value = BaseBean.getRequestMap().get(key);
            return value;
        }
        catch (NumberFormatException e) {
            log.error((Object)"ERROR in getStringFromRequestMap, key not found ", (Throwable)e);
            return null;
        }
    }

    public Lifecycle getCurrentDefaultLifecycleInstance() {
        if (this.lifecycle != null) {
            return this.lifecycle;
        }
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        return factory.getLifecycle("DEFAULT");
    }

    public static Integer getCurrentPhaseId() {
        HttpSession session = BaseBean.getSession();
        if (session != null) {
            Integer i = (Integer)session.getAttribute("jsfPhase");
            if (i == null) {
                return 0;
            }
            return i;
        }
        return 0;
    }

    public static String getFromViewId() {
        HttpSession session = BaseBean.getSession();
        if (session != null) {
            return (String)session.getAttribute("ploinFacesFromViewId");
        }
        return null;
    }

    public static Long getLifecycleId() {
        Long lifecycleId = 1L;
        if (BaseBean.getSession() != null && (lifecycleId = (Long)BaseBean.getSession().getAttribute("lifecycleId")) == null) {
            lifecycleId = 1L;
        }
        return lifecycleId;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public boolean removeFlow(String flowId) {
        Object o = BaseBean.getApplicationMap().get("ploinFlows");
        if (o != null && o instanceof List) {
            List flows = (List)o;
            FlowControl flowControl = new FlowControl();
            Flow flow = flowControl.getFlowById(flowId, flows);
            flowControl.leaveFlow(flow, BaseBean.getFacesContext(), BaseBean.getSession());
            return true;
        }
        return false;
    }
}

