/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.common;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import play.api.Application;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.http.HttpConfiguration;
import play.api.http.HttpConfiguration$;
import play.api.libs.crypto.CookieSigner;
import play.api.libs.crypto.CookieSignerProvider;
import play.api.mvc.CookieHeaderEncoding;
import play.api.mvc.DefaultCookieHeaderEncoding;
import play.api.mvc.DefaultFlashCookieBaker;
import play.api.mvc.DefaultSessionCookieBaker;
import play.api.mvc.FlashCookieBaker;
import play.api.mvc.SessionCookieBaker;
import play.api.mvc.request.DefaultRequestFactory;
import play.api.mvc.request.RequestFactory;
import play.core.server.ServerProvider;
import play.core.server.common.ForwardedHeaderHandler;
import play.core.server.common.ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$;
import play.core.server.common.ServerDebugInfo;
import play.core.server.common.ServerResultUtils;
import play.utils.InlineCache;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005Q4a\u0001D\u0007\u0002\u0002M)\u0002\"B\u000f\u0001\t\u0003y\u0002bB\u0017\u0001\u0005\u0004%IA\f\u0005\u0007w\u0001\u0001\u000b\u0011B\u0018\t\rq\u0002AQA\n>\u0011\u001d\t\u0005A1A\u0005\n\tCa!\u0015\u0001!\u0002\u0013\u0019\u0005\"\u0002*\u0001\t\u000b\u0019\u0006\"\u0002,\u0001\r#9\u0006\"B-\u0001\t+Q\u0006\"\u00025\u0001\t+I\u0007\"\u00028\u0001\t+y'a\u0003*fY>\fGmQ1dQ\u0016T!AD\b\u0002\r\r|W.\\8o\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0003%M\tAaY8sK*\tA#\u0001\u0003qY\u0006LXC\u0001\f%'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001\u0005E\u0002\"\u0001\tj\u0011!\u0004\t\u0003G\u0011b\u0001\u0001\u0002\u0004&\u0001\u0011\u0015\rA\n\u0002\u0002)F\u0011qE\u000b\t\u00031!J!!K\r\u0003\u000f9{G\u000f[5oOB\u0011\u0001dK\u0005\u0003Ye\u00111!\u00118z\u00035\u0011X\r\\8bI\u000e{WO\u001c;feV\tq\u0006\u0005\u00021s5\t\u0011G\u0003\u00023g\u00051\u0011\r^8nS\u000eT!\u0001N\u001b\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00027o\u0005!Q\u000f^5m\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u0019\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u00039\u0011X\r\\8bI\u000e{WO\u001c;fe\u0002\n1B]3m_\u0006$7i\\;oiV\ta\b\u0005\u0002\u0019\u007f%\u0011\u0001)\u0007\u0002\u0004\u0013:$\u0018a\u0003:fY>\fGmQ1dQ\u0016,\u0012a\u0011\t\u00051\u00113%%\u0003\u0002F3\tIa)\u001e8di&|g.\r\t\u0004\u000f&[U\"\u0001%\u000b\u0005YJ\u0012B\u0001&I\u0005\r!&/\u001f\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dN\t1!\u00199j\u0013\t\u0001VJA\u0006BaBd\u0017nY1uS>t\u0017\u0001\u0004:fY>\fGmQ1dQ\u0016\u0004\u0013AC2bG\",GM\u0012:p[R\u0011!\u0005\u0016\u0005\u0006+\u001e\u0001\rAR\u0001\u0007iJL\u0018\t\u001d9\u0002\u0017I,Gn\\1e-\u0006dW/\u001a\u000b\u0003EaCQ!\u0016\u0005A\u0002\u0019\u000bqB]3m_\u0006$G)\u001a2vO&sgm\u001c\u000b\u00047\u0006\u0014\u0007c\u0001\r]=&\u0011Q,\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0005z\u0016B\u00011\u000e\u0005=\u0019VM\u001d<fe\u0012+'-^4J]\u001a|\u0007\"B+\n\u0001\u00041\u0005\"B2\n\u0001\u0004!\u0017AD:feZ,'\u000f\u0015:pm&$WM\u001d\t\u0003K\u001al\u0011aD\u0005\u0003O>\u0011abU3sm\u0016\u0014\bK]8wS\u0012,'/A\fsK2|\u0017\rZ*feZ,'OU3tk2$X\u000b^5mgR\u0011!.\u001c\t\u0003C-L!\u0001\\\u0007\u0003#M+'O^3s%\u0016\u001cX\u000f\u001c;Vi&d7\u000fC\u0003V\u0015\u0001\u0007a)\u0001\u000fsK2|\u0017\r\u001a$pe^\f'\u000fZ3e\u0011\u0016\fG-\u001a:IC:$G.\u001a:\u0015\u0005A\u001c\bCA\u0011r\u0013\t\u0011XB\u0001\fG_J<\u0018M\u001d3fI\"+\u0017\rZ3s\u0011\u0006tG\r\\3s\u0011\u0015)6\u00021\u0001G\u0001")
public abstract class ReloadCache<T> {
    private final AtomicInteger reloadCounter = new AtomicInteger(0);
    private final Function1<Try<Application>, T> reloadCache = new InlineCache((Function1 & Serializable)tryApp -> {
        this.reloadCounter().incrementAndGet();
        return this.reloadValue((Try<Application>)tryApp);
    });

    private AtomicInteger reloadCounter() {
        return this.reloadCounter;
    }

    public final int reloadCount() {
        return this.reloadCounter().get();
    }

    private Function1<Try<Application>, T> reloadCache() {
        return this.reloadCache;
    }

    public final T cachedFrom(Try<Application> tryApp) {
        return (T)this.reloadCache().apply(tryApp);
    }

    public abstract T reloadValue(Try<Application> var1);

    public final Option<ServerDebugInfo> reloadDebugInfo(Try<Application> tryApp, ServerProvider serverProvider) {
        boolean bl;
        Try<Application> try_ = tryApp;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Application app = (Application)success.value();
            bl = BoxesRunTime.unboxToBoolean((Object)app.configuration().get("play.server.debug.addDebugInfoToRequests", ConfigLoader$.MODULE$.booleanLoader()));
        } else if (try_ instanceof Failure) {
            bl = true;
        } else {
            throw new MatchError(try_);
        }
        boolean enabled = bl;
        if (enabled) {
            return new Some((Object)new ServerDebugInfo(serverProvider, this.reloadCount()));
        }
        return None$.MODULE$;
    }

    public final ServerResultUtils reloadServerResultUtils(Try<Application> tryApp) {
        Tuple3 tuple3;
        Try<Application> try_ = tryApp;
        if (try_ instanceof Success) {
            DefaultRequestFactory defaultRequestFactory;
            Success success = (Success)try_;
            Application app = (Application)success.value();
            RequestFactory requestFactory = app.requestFactory();
            DefaultRequestFactory requestFactory2 = requestFactory instanceof DefaultRequestFactory ? (defaultRequestFactory = (DefaultRequestFactory)requestFactory) : new DefaultRequestFactory(app.httpConfiguration());
            tuple3 = new Tuple3((Object)requestFactory2.sessionBaker(), (Object)requestFactory2.flashBaker(), (Object)requestFactory2.cookieHeaderEncoding());
        } else if (try_ instanceof Failure) {
            HttpConfiguration httpConfig = new HttpConfiguration(HttpConfiguration$.MODULE$.apply$default$1(), HttpConfiguration$.MODULE$.apply$default$2(), HttpConfiguration$.MODULE$.apply$default$3(), HttpConfiguration$.MODULE$.apply$default$4(), HttpConfiguration$.MODULE$.apply$default$5(), HttpConfiguration$.MODULE$.apply$default$6(), HttpConfiguration$.MODULE$.apply$default$7(), HttpConfiguration$.MODULE$.apply$default$8());
            CookieSigner cookieSigner = new CookieSignerProvider(httpConfig.secret()).get();
            tuple3 = new Tuple3((Object)new DefaultSessionCookieBaker(httpConfig.session(), httpConfig.secret(), cookieSigner), (Object)new DefaultFlashCookieBaker(httpConfig.flash(), httpConfig.secret(), cookieSigner), (Object)new DefaultCookieHeaderEncoding(httpConfig.cookies()));
        } else {
            throw new MatchError(try_);
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        SessionCookieBaker sessionBaker = (SessionCookieBaker)tuple32._1();
        FlashCookieBaker flashBaker = (FlashCookieBaker)tuple32._2();
        CookieHeaderEncoding cookieHeaderEncoding = (CookieHeaderEncoding)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)sessionBaker, (Object)flashBaker, (Object)cookieHeaderEncoding);
        SessionCookieBaker sessionBaker2 = (SessionCookieBaker)tuple33._1();
        FlashCookieBaker flashBaker2 = (FlashCookieBaker)tuple33._2();
        CookieHeaderEncoding cookieHeaderEncoding2 = (CookieHeaderEncoding)tuple33._3();
        return new ServerResultUtils(sessionBaker2, flashBaker2, cookieHeaderEncoding2);
    }

    public final ForwardedHeaderHandler reloadForwardedHeaderHandler(Try<Application> tryApp) {
        ForwardedHeaderHandler.ForwardedHeaderHandlerConfig forwardedHeaderConfiguration = ForwardedHeaderHandler$ForwardedHeaderHandlerConfig$.MODULE$.apply((Option<Configuration>)tryApp.toOption().map((Function1 & Serializable)x$2 -> x$2.configuration()));
        return new ForwardedHeaderHandler(forwardedHeaderConfiguration);
    }
}

