/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.db.ConnectionPool;
import play.api.db.ConnectionPool$;
import play.api.db.DBApi;
import play.api.db.DBApiProvider$;
import play.api.db.DefaultDBApi;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.Injector;
import play.api.inject.NewInstanceInjector$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005M4A!\u0004\b\u0001+!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyBQa\u0012\u0001\u0005\u0002!CQa\u0012\u0001\u0005\u0002=C\u0001B\u0017\u0001\t\u0006\u0004%\taW\u0004\bA:\t\t\u0011#\u0001b\r\u001dia\"!A\t\u0002\tDQa\u0012\u0006\u0005\u0002\u0019Dqa\u001a\u0006\u0012\u0002\u0013\u0005\u0001NA\u0007E\u0005\u0006\u0003\u0018\u000e\u0015:pm&$WM\u001d\u0006\u0003\u001fA\t!\u0001\u001a2\u000b\u0005E\u0011\u0012aA1qS*\t1#\u0001\u0003qY\u0006L8\u0001A\n\u0004\u0001Yq\u0002CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011a\u0017M\\4\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007}!c%D\u0001!\u0015\t\t#%\u0001\u0004j]*,7\r\u001e\u0006\u0002G\u0005)!.\u0019<bq&\u0011Q\u0005\t\u0002\t!J|g/\u001b3feB\u0011q\u0005K\u0007\u0002\u001d%\u0011\u0011F\u0004\u0002\u0006\t\n\u000b\u0005/[\u0001\fK:4\u0018N]8o[\u0016tG\u000f\u0005\u0002-[5\t\u0001#\u0003\u0002/!\tYQI\u001c<je>tW.\u001a8u\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011A&M\u0005\u0003eA\u0011QbQ8oM&<WO]1uS>t\u0017!\u00063fM\u0006,H\u000e^\"p]:,7\r^5p]B{w\u000e\u001c\t\u0003OUJ!A\u000e\b\u0003\u001d\r{gN\\3di&|g\u000eU8pY\u0006IA.\u001b4fGf\u001cG.\u001a\t\u0003smj\u0011A\u000f\u0006\u0003CAI!\u0001\u0010\u001e\u0003)\u0005\u0003\b\u000f\\5dCRLwN\u001c'jM\u0016\u001c\u0017p\u00197f\u00035i\u0017-\u001f2f\u0013:TWm\u0019;peB\u0019qH\u0011#\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013aa\u00149uS>t\u0007CA\u001dF\u0013\t1%H\u0001\u0005J]*,7\r^8s\u0003\u0019a\u0014N\\5u}Q1\u0011JS&M\u001b:\u0003\"a\n\u0001\t\u000b)2\u0001\u0019A\u0016\t\u000b=2\u0001\u0019\u0001\u0019\t\u000bM2\u0001\u0019\u0001\u001b\t\u000b]2\u0001\u0019\u0001\u001d\t\u000bu2\u0001\u0019\u0001 \u0015\r%\u0003\u0016KU*U\u0011\u0015Qs\u00011\u0001,\u0011\u0015ys\u00011\u00011\u0011\u0015\u0019t\u00011\u00015\u0011\u00159t\u00011\u00019\u0011\u001d)v\u0001%AA\u0002\u0011\u000b\u0001\"\u001b8kK\u000e$xN\u001d\u0015\u0003\u000f]\u0003\"a\b-\n\u0005e\u0003#AB%oU\u0016\u001cG/A\u0002hKR,\u0012A\n\u0015\u0003\u0001u\u0003\"a\b0\n\u0005}\u0003#!C*j]\u001edW\r^8o\u00035!%)\u00119j!J|g/\u001b3feB\u0011qEC\n\u0003\u0015\r\u0004\"a\u00103\n\u0005\u0015\u0004%AB!osJ+g\rF\u0001b\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\t\u0011N\u000b\u0002EU.\n1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003a\u0002\u000b!\"\u00198o_R\fG/[8o\u0013\t\u0011XNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DBApiProvider
implements Provider<DBApi> {
    private DBApi get;
    private final Environment environment;
    private final Configuration configuration;
    private final ConnectionPool defaultConnectionPool;
    private ApplicationLifecycle lifecycle;
    private final Option<Injector> maybeInjector;
    private volatile boolean bitmap$0;

    public static Injector $lessinit$greater$default$5() {
        return DBApiProvider$.MODULE$.$lessinit$greater$default$5();
    }

    private DBApi get$lzycompute() {
        DBApiProvider dBApiProvider = this;
        synchronized (dBApiProvider) {
            if (!this.bitmap$0) {
                Config config = this.configuration.underlying();
                String dbKey = config.getString("play.db.config");
                ConnectionPool pool = (ConnectionPool)this.maybeInjector.map((Function1 & Serializable)injector -> ConnectionPool$.MODULE$.fromConfig(config.getString("play.db.pool"), (Injector)injector, $this.environment, $this.defaultConnectionPool)).getOrElse((Function0 & Serializable)() -> ConnectionPool$.MODULE$.fromConfig(config.getString("play.db.pool"), $this.environment, $this.defaultConnectionPool));
                Map configs = config.hasPath(dbKey) ? new Configuration(config).getPrototypedMap(dbKey, "play.db.prototype").view().mapValues((Function1 & Serializable)x$1 -> x$1.underlying()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : Predef$.MODULE$.Map().empty();
                DefaultDBApi db = new DefaultDBApi((Map<String, Config>)configs, pool, this.environment, (Injector)this.maybeInjector.getOrElse((Function0 & Serializable)() -> NewInstanceInjector$.MODULE$));
                this.lifecycle.addStopHook((Function0 & Serializable)() -> Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> db.shutdown())));
                Mode mode = this.environment.mode();
                Mode.Test$ test$ = Mode.Test$.MODULE$;
                db.initialize(mode == null ? test$ != null : !mode.equals(test$));
                this.get = db;
                this.bitmap$0 = true;
            }
        }
        this.lifecycle = null;
        return this.get;
    }

    public DBApi get() {
        if (!this.bitmap$0) {
            return this.get$lzycompute();
        }
        return this.get;
    }

    public DBApiProvider(Environment environment, Configuration configuration, ConnectionPool defaultConnectionPool, ApplicationLifecycle lifecycle, Option<Injector> maybeInjector) {
        this.environment = environment;
        this.configuration = configuration;
        this.defaultConnectionPool = defaultConnectionPool;
        this.lifecycle = lifecycle;
        this.maybeInjector = maybeInjector;
    }

    @Inject
    public DBApiProvider(Environment environment, Configuration configuration, ConnectionPool defaultConnectionPool, ApplicationLifecycle lifecycle, Injector injector) {
        this(environment, configuration, defaultConnectionPool, lifecycle, (Option<Injector>)Option$.MODULE$.apply((Object)injector));
    }
}

