/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven.report;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanWriteFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.maven.plugin.logging.Log;
import org.pitest.util.PitError;

public class ReportSourceLocator {
    static final FileFilter TIMESTAMPED_REPORTS_FILE_FILTER = new AndFileFilter(Arrays.asList(DirectoryFileFilter.DIRECTORY, new RegexFileFilter("^\\d+$"), CanWriteFileFilter.CAN_WRITE));

    public File locate(File reportsDirectory, Log log) {
        if (!reportsDirectory.exists()) {
            throw new PitError("could not find reports directory [" + String.valueOf(reportsDirectory) + "]");
        }
        if (!reportsDirectory.canRead()) {
            throw new PitError("reports directory [" + String.valueOf(reportsDirectory) + "] not readable");
        }
        if (!reportsDirectory.isDirectory()) {
            throw new PitError("reports directory [" + String.valueOf(reportsDirectory) + "] is actually a file, it must be a directory");
        }
        return this.executeLocator(reportsDirectory, log);
    }

    private File executeLocator(File reportsDirectory, Log log) {
        File[] subdirectories = reportsDirectory.listFiles(TIMESTAMPED_REPORTS_FILE_FILTER);
        File latest = reportsDirectory;
        log.debug((CharSequence)("ReportSourceLocator starting search in directory [" + reportsDirectory.getAbsolutePath() + "]"));
        if (subdirectories != null) {
            LastModifiedFileComparator c = new LastModifiedFileComparator();
            for (File f : subdirectories) {
                log.debug((CharSequence)("comparing directory [" + f.getAbsolutePath() + "] with the current latest directory of [" + latest.getAbsolutePath() + "]"));
                if (c.compare(latest, f) >= 0) continue;
                latest = f;
                log.debug((CharSequence)("directory [" + f.getAbsolutePath() + "] is now the latest"));
            }
        } else {
            throw new PitError("could not list files in directory [" + reportsDirectory.getAbsolutePath() + "] because of an unknown I/O error");
        }
        log.debug((CharSequence)("ReportSourceLocator determined directory [" + latest.getAbsolutePath() + "] is the directory containing the latest pit reports"));
        return latest;
    }
}

