/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.pitest.functional.Streams;
import org.pitest.mutationtest.SourceLocator;

public class DirectorySourceLocator
implements SourceLocator {
    private final File root;
    private final Function<File, Optional<Reader>> fileToReader;

    DirectorySourceLocator(File root, Function<File, Optional<Reader>> fileToReader) {
        this.root = root;
        this.fileToReader = fileToReader;
    }

    public DirectorySourceLocator(File root) {
        this(root, new FileToReader());
    }

    @Override
    public Optional<Reader> locate(Collection<String> classes, String fileName) {
        Stream<Reader> matches = classes.stream().flatMap(this.classNameToSourceFileReader(fileName));
        return matches.findFirst();
    }

    private Function<String, Stream<Reader>> classNameToSourceFileReader(String fileName) {
        return className -> {
            if (className.contains(".")) {
                File f = new File(className.replace(".", File.separator));
                return this.locate(f.getParent() + File.separator + fileName);
            }
            return this.locate(fileName);
        };
    }

    private Stream<Reader> locate(String fileName) {
        File f = new File(this.root + File.separator + fileName);
        return Streams.fromOptional(this.fileToReader.apply(f));
    }

    private static class FileToReader
    implements Function<File, Optional<Reader>> {
        private FileToReader() {
        }

        @Override
        public Optional<Reader> apply(File f) {
            if (f.exists()) {
                try {
                    return Optional.of(new FileReader(f));
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }
    }
}

