/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.mutators.returns.NullReturnValsMutator;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;

public class NullFlatMapFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> RETURN_EMPTY_STREAM = QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.methodCallTo(ClassName.fromClass(Stream.class), "empty")).then(InstructionMatchers.opCode(176).and(InstructionMatchers.isInstruction((SlotRead<AbstractInsnNode>)MUTATED_INSTRUCTION.read()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()).withDebug(false));
    private static final Slot<Location> METHOD_DESC = Slot.create(Location.class);
    static final SequenceMatcher<AbstractInsnNode> HAS_FLAT_MAP_CALL = QueryStart.any(AbstractInsnNode.class).then(NullFlatMapFilter.dynamicCallTo((SlotRead<Location>)METHOD_DESC.read())).then(InstructionMatchers.methodCallTo(ClassName.fromClass(Stream.class), "flatMap")).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(InstructionMatchers.isA(LabelNode.class))).withDebug(false));
    private ClassTree currentClass;
    private Map<Location, Boolean> calledOnlyByFlatMap;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
        this.calledOnlyByFlatMap = new HashMap<Location, Boolean>();
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater unused) {
        return mutations.stream().filter(m -> !this.isStreamEmptyMutantWithOnlyFlatMapCalls((MutationDetails)m)).collect(Collectors.toList());
    }

    private boolean isStreamEmptyMutantWithOnlyFlatMapCalls(MutationDetails mutationDetails) {
        if (!mutationDetails.getMutator().equals(NullReturnValsMutator.NULL_RETURNS.getGloballyUniqueId())) {
            return false;
        }
        MethodTree method = this.currentClass.method(mutationDetails.getId().getLocation()).get();
        if (!method.isPrivate() || !method.returns(ClassName.fromClass(Stream.class))) {
            return false;
        }
        Context context = Context.start(method.instructions(), (boolean)false);
        context.store(MUTATED_INSTRUCTION.write(), (Object)method.instruction(mutationDetails.getInstructionIndex()));
        return RETURN_EMPTY_STREAM.matches(method.instructions(), context) && this.calledOnlyByFlatMap.computeIfAbsent(mutationDetails.getId().getLocation(), this::calledOnlyFromFlatMap) != false;
    }

    private boolean calledOnlyFromFlatMap(Location location) {
        MethodTree mutated = this.currentClass.method(location).get();
        boolean flatMapCallFound = false;
        for (MethodTree each : this.currentClass.methods()) {
            if (!this.callsTarget(mutated, each) || (flatMapCallFound = this.isFlatMapCall(mutated, each))) continue;
            return false;
        }
        return flatMapCallFound;
    }

    private boolean callsTarget(MethodTree target, MethodTree method) {
        return method.instructions().stream().anyMatch(this.callTo(target.asLocation().getClassName(), target.asLocation().getMethodName(), target.asLocation().getMethodDesc()).or(NullFlatMapFilter.dynamicCallTo(target.asLocation())));
    }

    private Predicate<AbstractInsnNode> callTo(ClassName className, String name, String desc) {
        return n -> {
            if (n instanceof MethodInsnNode) {
                MethodInsnNode call = (MethodInsnNode)n;
                return call.owner.equals(className.asInternalName()) && call.name.equals(name) && call.desc.equals(desc);
            }
            return false;
        };
    }

    private boolean isFlatMapCall(MethodTree mutated, MethodTree each) {
        Context context = Context.start(each.instructions(), (boolean)false);
        context.store(METHOD_DESC.write(), (Object)mutated.asLocation());
        return HAS_FLAT_MAP_CALL.matches(each.instructions(), context);
    }

    private static Match<AbstractInsnNode> dynamicCallTo(SlotRead<Location> desc) {
        return (c, t) -> NullFlatMapFilter.dynamicCallTo((Location)c.retrieve(desc).get()).test((AbstractInsnNode)t);
    }

    private static Predicate<AbstractInsnNode> dynamicCallTo(Location desc) {
        return t -> {
            if (t instanceof InvokeDynamicInsnNode) {
                InvokeDynamicInsnNode call = (InvokeDynamicInsnNode)t;
                return Arrays.stream(call.bsmArgs).anyMatch(NullFlatMapFilter.isHandle(desc.getClassName(), desc.getMethodName(), desc.getMethodDesc()));
            }
            return false;
        };
    }

    private static Predicate<Object> isHandle(ClassName owner, String name, String desc) {
        return o -> {
            if (o instanceof Handle) {
                Handle handle = (Handle)o;
                return handle.getOwner().equals(owner.asInternalName()) && handle.getName().equals(name) && handle.getDesc().equals(desc);
            }
            return false;
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
        this.calledOnlyByFlatMap = null;
    }
}

