/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;

public final class MutationResult {
    private final MutationDetails details;
    private final MutationStatusTestPair status;

    public MutationResult(MutationDetails md, MutationStatusTestPair status) {
        this.details = md;
        this.status = status;
    }

    public String getId() {
        return this.details.getId().toString().replace(" ", "-");
    }

    public MutationDetails getDetails() {
        return this.details;
    }

    public Optional<String> getKillingTest() {
        return this.status.getKillingTest();
    }

    public List<String> getKillingTests() {
        return this.status.getKillingTests();
    }

    public List<String> getSucceedingTests() {
        return this.status.getSucceedingTests();
    }

    public List<String> getCoveringTests() {
        return this.status.getCoveringTests();
    }

    public DetectionStatus getStatus() {
        return this.status.getStatus();
    }

    public int getNumberOfTestsRun() {
        return this.status.getNumberOfTestsRun();
    }

    public MutationStatusTestPair getStatusTestPair() {
        return this.status;
    }

    public String getStatusDescription() {
        return this.getStatus().name();
    }

    public String getKillingTestDescription() {
        return this.getKillingTest().orElse("none");
    }

    public Boolean getSurvived() {
        return this.status.getStatus() == DetectionStatus.SURVIVED;
    }

    public int hashCode() {
        return Objects.hash(this.details, this.status);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MutationResult other = (MutationResult)obj;
        return Objects.equals(this.details, other.details) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "MutationResult [details=" + String.valueOf(this.details) + ", status=" + String.valueOf(this.status) + "]";
    }
}

