/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.classinfo.CachingByteArraySource;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.CoverageGenerator;
import org.pitest.coverage.CoverageSummary;
import org.pitest.coverage.NoCoverage;
import org.pitest.coverage.ReportCoverage;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.EngineArguments;
import org.pitest.mutationtest.History;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.MutationResultInterceptor;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.mutationtest.build.CompoundMutationInterceptor;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationSource;
import org.pitest.mutationtest.build.MutationTestBuilder;
import org.pitest.mutationtest.build.PercentAndConstantTimeoutStrategy;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.config.SettingsFactory;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.mutationtest.execute.MutationAnalysisExecutor;
import org.pitest.mutationtest.incremental.HistoryListener;
import org.pitest.mutationtest.incremental.NullHistory;
import org.pitest.mutationtest.statistics.MutationStatistics;
import org.pitest.mutationtest.statistics.MutationStatisticsListener;
import org.pitest.mutationtest.statistics.Score;
import org.pitest.mutationtest.tooling.CombinedStatistics;
import org.pitest.mutationtest.tooling.MutationStrategies;
import org.pitest.mutationtest.tooling.SmartSourceLocator;
import org.pitest.mutationtest.tooling.SpinnerListener;
import org.pitest.mutationtest.verify.BuildMessage;
import org.pitest.util.Log;
import org.pitest.util.StringUtil;
import org.pitest.util.Timings;
import org.pitest.util.Verbosity;

public class MutationCoverage {
    private static final int MB = 0x100000;
    private static final Logger LOG = Log.getLogger();
    private final ReportOptions data;
    private final MutationStrategies strategies;
    private final Timings timings;
    private final CodeSource code;
    private final File baseDir;
    private final SettingsFactory settings;

    public MutationCoverage(MutationStrategies strategies, File baseDir, CodeSource code, ReportOptions data, SettingsFactory settings, Timings timings) {
        this.strategies = strategies;
        this.data = data;
        this.settings = settings;
        this.timings = timings;
        this.code = code;
        this.baseDir = baseDir;
    }

    public CombinedStatistics runReport() throws IOException {
        if (!this.data.getVerbosity().showMinionOutput()) {
            LOG.info("Verbose logging is disabled. If you encounter a problem, please enable it before reporting an issue.");
        }
        Log.setVerbose((Verbosity)this.data.getVerbosity());
        Runtime runtime = Runtime.getRuntime();
        LOG.fine("Running report with " + this.data);
        LOG.fine("System class path is " + System.getProperty("java.class.path"));
        LOG.fine("Maximum available memory is " + runtime.maxMemory() / 0x100000L + " mb");
        long t0 = System.nanoTime();
        List<BuildMessage> issues = this.verifyBuildSuitableForMutationTesting();
        this.checkExcludedRunners();
        EngineArguments args = EngineArguments.arguments().withExcludedMethods(this.data.getExcludedMethods()).withMutators(this.data.getMutators());
        MutationEngine engine = this.strategies.factory().createEngine(args);
        List<MutationAnalysisUnit> preScanMutations = this.findMutations(engine, args);
        LOG.info("Created " + preScanMutations.size() + " mutation test units in pre scan");
        this.checkMutationsFound(preScanMutations);
        if (preScanMutations.isEmpty()) {
            LOG.info("Skipping coverage and analysis as no mutations found");
            return this.emptyStatistics();
        }
        List<MutationDetails> unfilteredMutants = preScanMutations.stream().flatMap(unit -> unit.mutants().stream()).collect(Collectors.toList());
        return this.runAnalysis(runtime, t0, args, engine, issues, unfilteredMutants);
    }

    private CombinedStatistics emptyStatistics() {
        MutationStatistics mutationStatistics = new MutationStatistics(Collections.emptyList(), 0L, 0L, 0L, 0L, Collections.emptySet());
        return new CombinedStatistics(mutationStatistics, new CoverageSummary(0, 0, 0), Collections.emptyList());
    }

    private CombinedStatistics runAnalysis(Runtime runtime, long t0, EngineArguments args, MutationEngine engine, List<BuildMessage> issues, List<MutationDetails> unfilteredMutants) {
        History history = this.strategies.history();
        history.initialize();
        CoverageDatabase coverageData = this.coverage().calculateCoverage(history.limitTests(unfilteredMutants));
        history.processCoverage(coverageData);
        LOG.fine("Used memory after coverage calculation " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + " mb");
        LOG.fine("Free Memory after coverage calculation " + runtime.freeMemory() / 0x100000L + " mb");
        this.timings.registerStart(Timings.Stage.BUILD_MUTATION_TESTS);
        List<MutationAnalysisUnit> tus = this.buildMutationTests(coverageData, history, engine, args, this.allInterceptors());
        this.timings.registerEnd(Timings.Stage.BUILD_MUTATION_TESTS);
        LOG.info("Created " + tus.size() + " mutation test units");
        LOG.fine("Used memory before analysis start " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + " mb");
        LOG.fine("Free Memory before analysis start " + runtime.freeMemory() / 0x100000L + " mb");
        ReportCoverage modifiedCoverage = this.transformCoverage(coverageData);
        MutationStatisticsListener stats = new MutationStatisticsListener();
        List<MutationResultListener> config = this.createConfig(t0, modifiedCoverage, history, stats, engine, issues);
        MutationAnalysisExecutor mae = new MutationAnalysisExecutor(this.numberOfThreads(), this.resultInterceptor(), config);
        this.timings.registerStart(Timings.Stage.RUN_MUTATION_TESTS);
        mae.run(tus);
        this.timings.registerEnd(Timings.Stage.RUN_MUTATION_TESTS);
        LOG.info("Completed in " + this.timeSpan(t0));
        MutationStatistics mutationStats = stats.getStatistics();
        CombinedStatistics combined = new CombinedStatistics(mutationStats, this.createSummary(coverageData.testCount(), modifiedCoverage, mutationStats.mutatedClasses()), issues);
        this.printStats(combined);
        return combined;
    }

    private ReportCoverage transformCoverage(ReportCoverage coverageData) {
        return this.strategies.coverageTransformer().transform(coverageData);
    }

    private CoverageSummary createSummary(int numberOfTests, ReportCoverage modifiedCoverage, Set<ClassName> mutatedClasses) {
        List examinedClasses = this.code.getCodeUnderTestNames().stream().filter(mutatedClasses::contains).collect(Collectors.toList());
        int numberOfCodeLines = examinedClasses.stream().map(c -> modifiedCoverage.getCodeLinesForClass((ClassName)c)).map(c -> c.getNumberOfCodeLines()).reduce(0, Integer::sum);
        int coveredLines = examinedClasses.stream().mapToInt(c -> modifiedCoverage.getCoveredLines((ClassName)c).size()).sum();
        return new CoverageSummary(numberOfCodeLines, coveredLines, numberOfTests);
    }

    private Predicate<MutationInterceptor> allInterceptors() {
        return i -> true;
    }

    private List<MutationAnalysisUnit> findMutations(MutationEngine engine, EngineArguments args) {
        this.timings.registerStart(Timings.Stage.MUTATION_PRE_SCAN);
        List<MutationAnalysisUnit> mutants = this.buildMutationTests(new NoCoverage(), new NullHistory(), engine, args, this.noReportsOrFilters());
        this.timings.registerEnd(Timings.Stage.MUTATION_PRE_SCAN);
        return mutants;
    }

    private Predicate<MutationInterceptor> noReportsOrFilters() {
        return i -> i.type().includeInPrescan();
    }

    private void checkExcludedRunners() {
        Collection<String> excludedRunners = this.data.getExcludedRunners();
        if (!excludedRunners.isEmpty()) {
            try {
                Class.forName("org.junit.runner.RunWith");
            }
            catch (ClassNotFoundException e) {
                throw new PitHelpError(Help.NO_JUNIT_EXCLUDE_RUNNERS, new Object[0]);
            }
        }
    }

    private int numberOfThreads() {
        return Math.max(1, this.data.getNumberOfThreads());
    }

    private List<MutationResultListener> createConfig(long t0, ReportCoverage coverageData, History history, MutationStatisticsListener stats, MutationEngine engine, List<BuildMessage> issues) {
        ArrayList<MutationResultListener> ls = new ArrayList<MutationResultListener>();
        ls.add(stats);
        ListenerArguments args = new ListenerArguments(this.strategies.output(), coverageData, new SmartSourceLocator(this.data.getSourcePaths(), this.data.getInputEncoding()), engine, t0, this.data.isFullMutationMatrix(), this.data, issues);
        MutationResultListener mutationReportListener = this.strategies.listenerFactory().getListener(this.data.getFreeFormProperties(), args);
        ls.add(mutationReportListener);
        ls.add(new HistoryListener(history));
        if (this.data.getVerbosity().showSpinner()) {
            ls.add(new SpinnerListener(System.out));
        }
        return ls;
    }

    private MutationResultInterceptor resultInterceptor() {
        return this.strategies.resultInterceptor();
    }

    private List<BuildMessage> verifyBuildSuitableForMutationTesting() {
        return this.strategies.buildVerifier().verifyBuild();
    }

    private void printStats(CombinedStatistics combinedStatistics) {
        MutationStatistics stats = combinedStatistics.getMutationStatistics();
        PrintStream ps = System.out;
        ps.println(StringUtil.separatorLine((char)'='));
        ps.println("- Mutators");
        ps.println(StringUtil.separatorLine((char)'='));
        for (Score each : stats.getScores()) {
            each.report(ps);
            ps.println(StringUtil.separatorLine());
        }
        ps.println(StringUtil.separatorLine((char)'='));
        ps.println("- Timings");
        ps.println(StringUtil.separatorLine((char)'='));
        this.timings.report(ps);
        ps.println(StringUtil.separatorLine((char)'='));
        ps.println("- Statistics");
        ps.println(StringUtil.separatorLine((char)'='));
        CoverageSummary coverage = combinedStatistics.getCoverageSummary();
        if (coverage != null) {
            ps.println(String.format(">> Line Coverage (for mutated classes only): %d/%d (%d%%)", coverage.getNumberOfCoveredLines(), coverage.getNumberOfLines(), coverage.getCoverage()));
            ps.println(String.format(">> %d tests examined", coverage.getNumberOfTests()));
        }
        stats.report(ps);
        if (!combinedStatistics.getIssues().isEmpty()) {
            ps.println();
            ps.println("Build messages:- ");
            combinedStatistics.getIssues().forEach(m -> ps.println("* " + m));
        }
    }

    private List<MutationAnalysisUnit> buildMutationTests(CoverageDatabase coverageData, History history, MutationEngine engine, EngineArguments args, Predicate<MutationInterceptor> interceptorFilter) {
        MutationConfig mutationConfig = new MutationConfig(engine, this.coverage().getLaunchOptions());
        CachingByteArraySource bas = new CachingByteArraySource(this.fallbackToClassLoader((ClassByteArraySource)new ClassPathByteArraySource(this.data.getClassPath())), 200);
        TestPrioritiser testPrioritiser = this.settings.getTestPrioritiser().makeTestPrioritiser(this.data.getFreeFormProperties(), this.code, coverageData);
        CompoundMutationInterceptor interceptor = this.settings.getInterceptor().createInterceptor(this.data, coverageData, (ClassByteArraySource)bas, testPrioritiser, this.code).filter(interceptorFilter);
        interceptor.initialise(this.code);
        MutationSource source = new MutationSource(mutationConfig, testPrioritiser, (ClassByteArraySource)bas, interceptor);
        WorkerFactory wf = new WorkerFactory(this.baseDir, this.coverage().getConfiguration(), mutationConfig, args, (TimeoutLengthStrategy)new PercentAndConstantTimeoutStrategy(this.data.getTimeoutFactor(), this.data.getTimeoutConstant()), this.data.getVerbosity(), this.data.isFullMutationMatrix(), this.data.getClassPath().getLocalClassPath());
        MutationGrouper grouper = this.settings.getMutationGrouper().makeFactory(this.data.getFreeFormProperties(), this.code, this.data.getNumberOfThreads(), this.data.getMutationUnitSize());
        MutationTestBuilder builder = new MutationTestBuilder(this.data.mode(), wf, history, source, grouper);
        return builder.createMutationTestUnits(this.code.getCodeUnderTestNames());
    }

    private void checkMutationsFound(List<MutationAnalysisUnit> tus) {
        if (tus.isEmpty()) {
            if (this.data.shouldFailWhenNoMutations()) {
                throw new PitHelpError(Help.NO_MUTATIONS_FOUND, new Object[0]);
            }
            LOG.warning(Help.NO_MUTATIONS_FOUND.toString());
        }
    }

    private String timeSpan(long t0) {
        return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - t0) + " seconds";
    }

    private CoverageGenerator coverage() {
        return this.strategies.coverage();
    }

    private ClassByteArraySource fallbackToClassLoader(ClassByteArraySource bas) {
        ClassloaderByteArraySource clSource = ClassloaderByteArraySource.fromContext();
        return arg_0 -> MutationCoverage.lambda$fallbackToClassLoader$7(bas, (ClassByteArraySource)clSource, arg_0);
    }

    private static /* synthetic */ Optional lambda$fallbackToClassLoader$7(ClassByteArraySource bas, ClassByteArraySource clSource, String clazz) {
        Optional maybeBytes = bas.getBytes(clazz);
        if (maybeBytes.isPresent()) {
            return maybeBytes;
        }
        return clSource.getBytes(clazz);
    }
}

