/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.process;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.web.core.HTTPContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLHandlerChainProcessor {
    private Set<SAML2Handler> handlers = new HashSet<SAML2Handler>();

    public SAMLHandlerChainProcessor(Set<SAML2Handler> handlers) {
        this.handlers.addAll(handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callHandlerChain(SAML2Object samlObject, SAML2HandlerRequest saml2HandlerRequest, SAML2HandlerResponse saml2HandlerResponse, HTTPContext httpContext, Lock chainLock) throws ProcessingException, IOException {
        try {
            chainLock.lock();
            for (SAML2Handler handler : this.handlers) {
                if (saml2HandlerResponse.isInError()) {
                    httpContext.getResponse().sendError(saml2HandlerResponse.getErrorCode());
                    break;
                }
                if (samlObject instanceof RequestAbstractType) {
                    handler.handleRequestType(saml2HandlerRequest, saml2HandlerResponse);
                    continue;
                }
                handler.handleStatusResponseType(saml2HandlerRequest, saml2HandlerResponse);
            }
        }
        finally {
            chainLock.unlock();
        }
    }
}

