/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.cert.X509Certificate;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.http.credentials.X509Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CredentialsExtractor
implements CredentialsExtractor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509CredentialsExtractor.class);
    public static final String CERTIFICATE_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";

    public Optional<Credentials> extract(CallContext ctx) {
        Optional certificates = ctx.webContext().getRequestAttribute(CERTIFICATE_REQUEST_ATTRIBUTE);
        if (certificates.isPresent() && ((X509Certificate[])certificates.get()).length > 0) {
            X509Certificate certificate = ((X509Certificate[])certificates.get())[0];
            LOGGER.debug("X509 certificate: {}", (Object)certificate);
            return Optional.of(new X509Credentials(certificate));
        }
        LOGGER.debug("No X509 certificate in request");
        return Optional.empty();
    }
}

