/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator;

import java.util.Optional;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.authenticator.AbstractRegexpAuthenticator;
import org.pac4j.http.profile.IpProfile;

public class IpRegexpAuthenticator
extends AbstractRegexpAuthenticator
implements Authenticator {
    public IpRegexpAuthenticator() {
    }

    public IpRegexpAuthenticator(String regexpPattern) {
        this.setRegexpPattern(regexpPattern);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"pattern", (Object)this.pattern);
        this.setProfileDefinitionIfUndefined((ProfileDefinition)new CommonProfileDefinition(x -> new IpProfile()));
    }

    public Optional<Credentials> validate(CallContext ctx, Credentials credentials) {
        this.init();
        String ip = ((TokenCredentials)credentials).getToken();
        if (!this.pattern.matcher(ip).matches()) {
            throw new CredentialsException("Unauthorized IP address: " + ip);
        }
        IpProfile profile = (IpProfile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setId(ip);
        this.logger.debug("profile: {}", (Object)profile);
        credentials.setUserProfile((UserProfile)profile);
        return Optional.of(credentials);
    }
}

