/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.indirect;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;

public class IndirectBasicAuthClient
extends IndirectClient {
    private String realmName = "authentication required";

    public IndirectBasicAuthClient() {
    }

    public IndirectBasicAuthClient(Authenticator usernamePasswordAuthenticator) {
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
    }

    public IndirectBasicAuthClient(String realmName, Authenticator usernamePasswordAuthenticator) {
        this.realmName = realmName;
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
    }

    public IndirectBasicAuthClient(Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticatorIfUndefined(usernamePasswordAuthenticator);
        this.setProfileCreatorIfUndefined(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"realmName", (String)this.realmName);
        this.setRedirectionActionBuilderIfUndefined(ctx -> {
            WebContext webContext = ctx.webContext();
            return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)this.computeFinalCallbackUrl(webContext)));
        });
        this.setCredentialsExtractorIfUndefined((CredentialsExtractor)new BasicAuthExtractor());
    }

    public Optional<Credentials> getCredentials(CallContext ctx) {
        this.init();
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        WebContext webContext = ctx.webContext();
        webContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        try {
            Optional credentials = this.getCredentialsExtractor().extract(ctx);
            this.logger.debug("credentials : {}", (Object)credentials);
            if (!credentials.isPresent()) {
                throw HttpActionHelper.buildUnauthenticatedAction((WebContext)webContext);
            }
            return credentials;
        }
        catch (CredentialsException e) {
            throw HttpActionHelper.buildUnauthenticatedAction((WebContext)webContext);
        }
    }

    protected Optional<Credentials> internalValidateCredentials(CallContext ctx, Credentials credentials) {
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        WebContext webContext = ctx.webContext();
        webContext.setResponseHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        try {
            return this.getAuthenticator().validate(ctx, credentials);
        }
        catch (CredentialsException e) {
            throw HttpActionHelper.buildUnauthenticatedAction((WebContext)webContext);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRealmName() {
        return this.realmName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "IndirectBasicAuthClient(super=" + super.toString() + ", realmName=" + this.realmName + ")";
    }
}

