/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import org.owasp.dependencycheck.utils.Filter;

public class ArtifactScopeExcluded
extends Filter<String> {
    private final boolean skipTestScope;
    private final boolean skipProvidedScope;
    private final boolean skipSystemScope;
    private final boolean skipRuntimeScope;

    public ArtifactScopeExcluded(boolean skipTestScope, boolean skipProvidedScope, boolean skipSystemScope, boolean skipRuntimeScope) {
        this.skipTestScope = skipTestScope;
        this.skipProvidedScope = skipProvidedScope;
        this.skipSystemScope = skipSystemScope;
        this.skipRuntimeScope = skipRuntimeScope;
    }

    public boolean passes(String scope) {
        if (this.skipTestScope && "test".equals(scope)) {
            return true;
        }
        if (this.skipProvidedScope && "provided".equals(scope)) {
            return true;
        }
        if (this.skipSystemScope && "system".equals(scope)) {
            return true;
        }
        if (this.skipRuntimeScope && "runtime".equals(scope)) {
            return true;
        }
        return this.skipRuntimeScope && this.skipSystemScope && "compile+runtime".equals(scope);
    }
}

