/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomParseException;
import org.owasp.dependencycheck.xml.pom.PomParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

@ThreadSafe
public final class PomUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomUtils.class);

    private PomUtils() {
    }

    public static Model readPom(File file) throws AnalysisException {
        Model model = null;
        PomParser parser = new PomParser();
        try {
            model = parser.parse(file);
        }
        catch (PomParseException ex) {
            if (ex.getCause() instanceof SAXParseException) {
                try {
                    model = parser.parseWithoutDocTypeCleanup(file);
                }
                catch (PomParseException ex1) {
                    LOGGER.warn("Unable to parse pom '{}'", (Object)file.getPath());
                    LOGGER.debug("", (Throwable)ex1);
                    throw new AnalysisException(ex1);
                }
            }
            if (model == null) {
                LOGGER.warn("Unable to parse pom '{}'", (Object)file.getPath());
                LOGGER.debug("", (Throwable)ex);
                throw new AnalysisException(ex);
            }
        }
        catch (Throwable ex) {
            LOGGER.warn("Unexpected error during parsing of the pom '{}'", (Object)file.getPath());
            LOGGER.debug("", ex);
            throw new AnalysisException(ex);
        }
        if (model == null) {
            throw new AnalysisException(String.format("Unable to parse pom '%s'", file.getPath()));
        }
        return model;
    }

    public static Model readPom(String path, JarFile jar) throws AnalysisException {
        ZipEntry entry = jar.getEntry(path);
        PomParser parser = new PomParser();
        Model model = null;
        if (entry != null) {
            try {
                model = parser.parse(jar.getInputStream(entry));
            }
            catch (PomParseException ex) {
                if (ex.getCause() instanceof SAXParseException) {
                    try {
                        model = parser.parseWithoutDocTypeCleanup(jar.getInputStream(entry));
                    }
                    catch (PomParseException ex1) {
                        LOGGER.warn("Unable to parse pom '{}' in jar '{}'", (Object)path, (Object)jar.getName());
                        LOGGER.debug("", (Throwable)ex1);
                        throw new AnalysisException(ex1);
                    }
                    catch (IOException ex1) {
                        LOGGER.warn("Unable to parse pom '{}' in jar '{}' (IO Exception)", (Object)path, (Object)jar.getName());
                        LOGGER.debug("", (Throwable)ex);
                        throw new AnalysisException(ex);
                    }
                }
                if (model != null) {
                    LOGGER.warn("Unable to parse pom '{}' in jar '{}'", (Object)path, (Object)jar.getName());
                    LOGGER.debug("", (Throwable)ex);
                    throw new AnalysisException(ex);
                }
            }
            catch (SecurityException ex) {
                LOGGER.warn("Unable to parse pom '{}' in jar '{}'; invalid signature", (Object)path, (Object)jar.getName());
                LOGGER.debug("", (Throwable)ex);
                throw new AnalysisException(ex);
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to parse pom '{}' in jar '{}' (IO Exception)", (Object)path, (Object)jar.getName());
                LOGGER.debug("", (Throwable)ex);
                throw new AnalysisException(ex);
            }
            catch (Throwable ex) {
                LOGGER.warn("Unexpected error during parsing of the pom '{}' in jar '{}'", (Object)path, (Object)jar.getName());
                LOGGER.debug("", ex);
                throw new AnalysisException(ex);
            }
            if (model == null) {
                throw new AnalysisException(String.format("Unable to parse pom '%s/%s'", jar.getName(), path));
            }
        }
        return model;
    }

    public static void analyzePOM(Dependency dependency, File pomFile) throws AnalysisException {
        Model pom = PomUtils.readPom(pomFile);
        JarAnalyzer.setPomEvidence(dependency, pom, null, true);
    }
}

