/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.specification.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static int getJavaUpdateVersion() {
        String runtimeVersion = System.getProperty("java.version");
        return Utils.parseUpdate(runtimeVersion);
    }

    protected static int parseUpdate(String runtimeVersion) {
        LOGGER.debug(runtimeVersion);
        try {
            String[] parts = runtimeVersion.split("\\.");
            if (parts.length == 4 && Utils.isNumeric(parts)) {
                return Integer.parseInt(parts[2]);
            }
            int pos = runtimeVersion.indexOf(95);
            if (pos <= 0 && (pos = runtimeVersion.lastIndexOf(46)) <= 0) {
                return 0;
            }
            int end = runtimeVersion.indexOf(43, pos);
            if (end < 0) {
                end = runtimeVersion.indexOf(45, pos);
            }
            if (end > pos) {
                return Integer.parseInt(runtimeVersion.substring(pos + 1, end));
            }
            return Integer.parseInt(runtimeVersion.substring(pos + 1));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private static boolean isNumeric(String[] parts) {
        for (String i : parts) {
            if (StringUtils.isNumeric((CharSequence)i)) continue;
            return false;
        }
        return true;
    }
}

