/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class CarthageAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "ios";
    private static final Logger LOGGER = LoggerFactory.getLogger(CarthageAnalyzer.class);
    private static final String ANALYZER_NAME = "Carthage Package Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String CARTFILE_RESOLVED = "Cartfile.resolved";
    private static final FileFilter CARTHAGE_FILTER = FileFilterBuilder.newInstance().addFilenames("Cartfile.resolved").build();
    private static final Pattern CARTFILE_RESOLVED_DEPENDENCY_PATTERN = Pattern.compile("(github|git|binary) \"([^\"]+)\" \"([^\"]+)\"");
    private static final Pattern CARTFILE_VERSION_PATTERN = Pattern.compile("^v?(\\d+(\\.\\d+){0,4})$");
    private static final Pattern CARTFILE_RESOLVED_GITHUB_DEPENDENCY = Pattern.compile("[a-zA-Z0-9-_]+/([a-zA-Z0-9\\-_\\.]+)");
    private static final Pattern CARTFILE_RESOLVED_GIT_DEPENDENCY = Pattern.compile(".*?/([a-zA-Z0-9\\-_\\.]+).git");
    private static final Pattern CARTFILE_RESOLVED_BINARY_DEPENDENCY = Pattern.compile("([a-zA-Z0-9\\-_\\.]+).json");

    @Override
    protected FileFilter getFileFilter() {
        return CARTHAGE_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.carthage.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (CARTFILE_RESOLVED.equals(dependency.getFileName())) {
            this.analyzeCartfileResolvedDependency(dependency, engine);
        }
    }

    private void analyzeCartfileResolvedDependency(Dependency cartfileResolved, Engine engine) throws AnalysisException {
        String contents;
        engine.removeDependency(cartfileResolved);
        try {
            contents = new String(Files.readAllBytes(cartfileResolved.getActualFile().toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = CARTFILE_RESOLVED_DEPENDENCY_PATTERN.matcher(contents);
        while (matcher.find()) {
            Matcher nameMatcher;
            String type = matcher.group(1);
            String name = matcher.group(2);
            String version = matcher.group(3);
            Matcher versionMatcher = CARTFILE_VERSION_PATTERN.matcher(version);
            version = versionMatcher.find() ? versionMatcher.group(1) : "0.0.0";
            if (type.contentEquals("git")) {
                nameMatcher = CARTFILE_RESOLVED_GIT_DEPENDENCY.matcher(name);
                if (!nameMatcher.find()) continue;
                name = nameMatcher.group(1);
            } else if (type.contentEquals("github")) {
                nameMatcher = CARTFILE_RESOLVED_GITHUB_DEPENDENCY.matcher(name);
                if (!nameMatcher.find()) continue;
                name = nameMatcher.group(1);
            } else if (type.contentEquals("binary")) {
                nameMatcher = CARTFILE_RESOLVED_BINARY_DEPENDENCY.matcher(name);
                if (!nameMatcher.find()) continue;
                name = nameMatcher.group(1);
            }
            Dependency dependency = new Dependency(cartfileResolved.getActualFile(), true);
            dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
            dependency.setName(name);
            dependency.setVersion(version);
            try {
                PackageURLBuilder builder = PackageURLBuilder.aPackageURL().withType("carthage").withName(dependency.getName());
                if (dependency.getVersion() != null) {
                    builder.withVersion(dependency.getVersion());
                }
                PackageURL purl = builder.build();
                dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to build package url for carthage", (Throwable)ex);
                GenericIdentifier id = dependency.getVersion() != null ? new GenericIdentifier("carthage:" + dependency.getName() + "@" + dependency.getVersion(), Confidence.HIGHEST) : new GenericIdentifier("carthage:" + dependency.getName(), Confidence.HIGHEST);
                dependency.addSoftwareIdentifier(id);
            }
            String packagePath = String.format("%s:%s", name, version);
            dependency.setPackagePath(packagePath);
            dependency.setDisplayFileName(packagePath);
            dependency.setSha1sum(Checksum.getSHA1Checksum((String)packagePath));
            dependency.setSha256sum(Checksum.getSHA256Checksum((String)packagePath));
            dependency.setMd5sum(Checksum.getMD5Checksum((String)packagePath));
            dependency.addEvidence(EvidenceType.VENDOR, CARTFILE_RESOLVED, "name", name, Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.PRODUCT, CARTFILE_RESOLVED, "name", name, Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.VERSION, CARTFILE_RESOLVED, "version", version, Confidence.HIGHEST);
            engine.addDependency(dependency);
        }
    }

    private void setPackagePath(Dependency dep) {
        File file = new File(dep.getFilePath());
        String parent = file.getParent();
        if (parent != null) {
            dep.setPackagePath(parent);
        }
    }
}

