/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.visitor;

import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.IPoolMetadata;
import org.ow2.util.pool.impl.PoolConfiguration;
import org.ow2.util.scan.api.IAnnotationVisitor;

public class PoolVisitor
implements IAnnotationVisitor {
    public static final String TYPE = "Lorg/ow2/util/pool/annotation/Pool;";
    private static final String MAX = "max";
    private static final String TIMEOUT = "timeout";
    private static final String MAX_WAITERS = "maxwaiters";
    private IPoolMetadata poolMetadata = null;

    public PoolVisitor(IPoolMetadata poolMetadata) {
        this.poolMetadata = poolMetadata;
    }

    public void visitEnd() {
        this.poolMetadata.setPoolConfiguration(this.getPoolConfiguration());
    }

    public IPoolConfiguration getPoolConfiguration() {
        IPoolConfiguration poolConfiguration = this.poolMetadata.getPoolConfiguration();
        if (poolConfiguration == null) {
            poolConfiguration = new PoolConfiguration();
            this.poolMetadata.setPoolConfiguration(poolConfiguration);
        }
        return poolConfiguration;
    }

    public void visit(String name, Object value) {
        if (MAX.equals(name)) {
            this.getPoolConfiguration().setMax(((Integer)value).intValue());
        } else if (TIMEOUT.equals(name)) {
            this.getPoolConfiguration().setMaxWaiters(((Integer)value).intValue());
        } else if (MAX_WAITERS.equals(name)) {
            this.getPoolConfiguration().setTimeout(((Long)value).longValue());
        }
    }

    public void visitEnum(String name, String desc, String value) {
    }

    public IAnnotationVisitor visitAnnotation(String name, String desc) {
        return this;
    }

    public IAnnotationVisitor visitArray(String name) {
        return this;
    }

    public String getType() {
        return TYPE;
    }
}

