/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProgressEvent.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.spi.status;

import java.util.EventObject;

import javax.enterprise.deploy.spi.TargetModuleID;

/**
 * An event which indicates that a deployment status change has occurred.
 * @author Guillaume Sauthier
 */
public class ProgressEvent extends EventObject {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = 7815118532096485937L;

    /**
     * Target ID.
     */
    private TargetModuleID targetId;

    /**
     * Status.
     */
    private DeploymentStatus status;

    /**
     * Creates a new object representing a deployment progress event.
     * @param source the object on which the Event initially occurred.
     * @param targetModuleID Module Target ID.
     * @param sCode the object containing the status information.
     */
    public ProgressEvent(Object source,
                         TargetModuleID targetModuleID,
                         DeploymentStatus sCode) {
        super(source);
        this.targetId = targetModuleID;
        this.status = sCode;
    }

    /**
     * Retrieve the TargetModuleID for this event.
     * @return the object containing the TargetModuleID
     */
    public TargetModuleID getTargetModuleID() {
        return this.targetId;
    }

    /**
     * Retrieve the status information.
     * @return the object containing the status information.
     */
    public DeploymentStatus getDeploymentStatus() {
        return this.status;
    }

}
