/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeploymentStatus.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.spi.status;

import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;

/**
 * The DeploymentStatus interface provides information about the progress status
 * of a deployment action.
 * @author Guillaume Sauthier
 */
public interface DeploymentStatus {

    /**
     * Retrieve the StateType value.
     * @return the StateType object
     */
    StateType getState();

    /**
     * Retrieve the deployment CommandType of this event.
     * @return the CommandType Object
     */
    CommandType getCommand();

    /**
     * Retrieve the deployment ActionType for this event.
     * @return the ActionType Object
     */
    ActionType getAction();

    /**
     * Retrieve any additional information about the status of this event.
     * @return message text
     */
    String getMessage();

    /**
     * A convenience method to report if the operation is in the completed state.
     * @return true if this command has completed successfully
     */
    boolean isCompleted();

    /**
     * A convenience method to report if the operation is in the failed state.
     * @return true if this command has failed
     */
    boolean isFailed();

    /**
     * A convenience method to report if the operation is in the running state.
     * @return true if this command is still running
     */
    boolean isRunning();
}
