/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: BeanNotFoundException.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.spi.exceptions;

/**
 * This exception is to report that the bean is not a child of the parent bean.
 * @author Guillaume Sauthier
 */
public class BeanNotFoundException extends Exception {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = -3319141583318924489L;

    /**
     * Creates an new BeanNotFoundException object.
     * @param message a string indicating what was wrong with the target.
     */
    public BeanNotFoundException(String message) {
        super(message);
    }

}
