/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TargetModuleID.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.spi;

/**
 * A TargetModuleID interface represents a unique identifier for a deployed
 * application module. A deployable application module can be an EAR, JAR,
 * WAR or RAR file. A TargetModuleID can represent a root module or a child
 * module. A root module TargetModuleID has no parent. It represents a deployed
 * EAR file or stand alone module. A child module TargetModuleID represents a
 * deployed sub module of a J2EE application. A child TargetModuleID has only
 * one parent, the super module it was bundled and deployed with. The identifier
 * consists of the target name and the unique identifier for the deployed
 * application module.
 * @author Guillaume Sauthier
 */
public interface TargetModuleID {

    /**
     * Retrieve the name of the target server. this module was deployed to.
     * @return Target an object representing a server target.
     */
    Target getTarget();

    /**
     * Retrieve the id assigned to represent the deployed module.
     */
    String getModuleID();

    /**
     * If this TargetModulID represents a web module retrieve the URL for it.
     * @return the URL of a web module or null if the module is not a web module.
     */
    String getWebURL();

    /**
     * Retrieve the identifier representing the deployed module.
     */
    String toString();

    /**
     * Retrieve the identifier of the parent object of this deployed module. If
     * there is no parent then this is the root object deployed. The root could
     * represent an EAR file or it could be a stand alone module that was deployed.
     * @return the TargetModuleID of the parent of this object. A null value
     *         means this module is the root object deployed.
     */
    TargetModuleID getParentTargetModuleID();

    /**
     * Retrieve a list of identifiers of the children of this deployed module.
     * @return a list of TargetModuleIDs identifying the children of this
     *         object. A null value means this module has no children.
     */
    TargetModuleID[] getChildTargetModuleID();


}
