/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DConfigBeanRoot.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.spi;

import javax.enterprise.deploy.model.DDBeanRoot;

/**
 * A J2EE component module consists of one or more deployment descriptor files and
 * zero or more non-deployment descriptor XML instance documents. A module must
 * contain a component-specific deployment descriptor file (see the component
 * specification for details). It may contain one or more secondary deployment
 * descriptor files that define extra functionality on the component and zero or
 * more non-deployment descriptor XML instance documents (see the Web Services
 * specification).<br/>
 *
 * The DConfigBeanRoot object is a deployment configuration bean (DConfigBean)
 * that is associated with the root of the component's deployment descriptor.
 * It must be created by calling the DeploymentConfiguration.getDConfigBean(DDBeanRoot)
 * method, where DDBeanRoot represents the component's deployment descriptor.<br/>
 *
 * A DConfigBean object is associated with a deployment descriptor that extends a
 * component's functionality. It must be created by calling the
 * DConfigBeanRoot.getDConfigBean(DDBeanRoot) method. This DConfigBean object is a
 * child of the compontent's DConfigBeanRoot object. The DDBeanRoot argument represents
 * the secondary deployment descriptor. Deployment descriptor files such as
 * webservice.xml and webserviceclient.xml are examples of secondary deployment
 * descriptor files.<br/>
 *
 * The server plug-in must request a DDBeanRoot object for any non-deployment
 * descriptor XML instance document data it requires. The plug-in must call method
 * DeployableObject.getDDBeanRoot(String) where String is the full path name from
 * the root of the module to the file to be represented. A WSDL file is an example
 * of a non-deployment descriptor XML instance document.
 * @author Guillaume Sauthier
 */
public interface DConfigBeanRoot extends DConfigBean {

    /**
     * Return a DConfigBean for a deployment descriptor that is not the module's
     * primary deployment descriptor. Web services provides a deployment descriptor
     * in addition to the module's primary deployment descriptor. Only the DDBeanRoot
     * for this category of secondary deployment descriptors are to be passed as
     * arguments through this method. Web service has two deployment descriptor
     * files, one that defines the web service and one that defines a client of
     * a web service. See the Web Service specification for the details.
     * @param ddBeanRoot represents the root element of a deployment descriptor file.
     * @return a DConfigBean to be used for processing this deployment descriptor data.
     *         Null may be returned if no DConfigBean is required for this deployment
     *         descriptor.
     */
    DConfigBean getDConfigBean(DDBeanRoot ddBeanRoot);
}
