/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ModuleType.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.shared;

/**
 * Class ModuleTypes defines enumeration values for the J2EE module types.
 * @author Guillaume Sauthier
 */
public class ModuleType {

    /**
     * The module is an EAR archive.
     */
    public static final ModuleType EAR = new ModuleType(0);

    /**
     * The module is an Enterprise Java Bean archive.
     */
    public static final ModuleType EJB = new ModuleType(1);

    /**
     * The module is an Client Application archive.
     */
    public static final ModuleType CAR = new ModuleType(2);

    /**
     * The module is an Connector archive.
     */
    public static final ModuleType RAR = new ModuleType(3);

    /**
     * The module is an Web Application archive.
     */
    public static final ModuleType WAR = new ModuleType(4);

    /**
     * Module type.
     */
    private int value;

    /**
     * Supported type table.
     */
    private static final ModuleType[] enumValueTable = {
        EAR,
        EJB,
        CAR,
        RAR,
        WAR,
    };

    /**
     * Supported type's name table.
     */
    private static final String[] stringTable = {
        "ear",
        "ejb",
        "car",
        "rar",
        "war",
    };

    /**
     * Supported type's extensions.
     */
    private static final String[] moduleExtensionTable = {
        ".ear",
        ".jar",
        ".jar",
        ".rar",
        ".war",
    };

    /**
     * Construct a new enumeration value with the given integer value.
     * @param value Integer value.
     */
    protected ModuleType(int value) {
        this.value = value;
    }

    /**
     * Returns this enumeration value's integer value.
     * @return the value
     */
    public int getValue() {
        return this.value;
    }

    /**
     * Returns the string table for class ModuleType
     */
    protected String[] getStringTable() {
        return stringTable;
    }

    /**
     * Returns the enumeration value table for class ModuleType
     */
    protected ModuleType[] getEnumValueTable() {
        return enumValueTable;
    }

    /**
     * Return the file extension string for this enumeration.
     */
    public String getModuleExtension() {
        return moduleExtensionTable[this.value];
    }

    /**
     * Return an object of the specified value.
     * @param value a designator for the object.
     */
    public static ModuleType getModuleType(int value) {
        return enumValueTable[value];
    }

    /**
     * Return the string name of this ModuleType or the integer value if
     * outside the bounds of the table
     */
    public String toString() {
        if (this.value >= 0 && this.value <= stringTable.length) {
            return stringTable[value];
        } else {
            return String.valueOf(value);
        }
    }

    /**
     * Returns the lowest integer value used by this enumeration value's
     * enumeration class.<br/>
     *
     * The default implementation returns 0. If the enumeration class (a
     * subclass of class EnumSyntax) uses integer values starting at other
     * than 0, override this method in the subclass.
     * @return the offset of the lowest enumeration value.
     */
    protected int getOffset() {
        return 0;
    }
}
