/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CommandType.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.shared;

/**
 * Class CommandTypes defines enumeration values for the DeploymentStatus object.
 * @author Guillaume Sauthier
 */
public class CommandType {

    /**
     * The DeploymentManger action operation being processed is distribute.
     */
    public static final CommandType DISTRIBUTE = new CommandType(0);

    /**
     * The DeploymentManger action operation being processed is start.
     */
    public static final CommandType START = new CommandType(1);

    /**
     * The DeploymentManger action operation being processed is stop.
     */
    public static final CommandType STOP = new CommandType(2);

    /**
     * The DeploymentManger action operation being processed is undeploy.
     */
    public static final CommandType UNDEPLOY = new CommandType(3);

    /**
     * The DeploymentManger action operation being processed is redeploy.
     */
    public static final CommandType REDEPLOY = new CommandType(4);

    /**
     * Action value.
     */
    private int value;

    /**
     * Supported type table.
     */
    private static final CommandType[] enumValueTable = {
        DISTRIBUTE,
        START,
        STOP,
        UNDEPLOY,
        REDEPLOY
    };

    /**
     * Supported type's name table.
     */
    private static final String[] stringTable = {
        "distribute",
        "start",
        "stop",
        "undeploy",
        "redeploy"
    };

    /**
     * Construct a new enumeration value with the given integer value.
     * @param valueInteger value.
     */
    protected CommandType(int value) {
        this.value = value;
    }

    /**
     * Returns this enumeration value's integer value.
     * @return the value.
     */
    public int getValue() {
        return this.value;
    }

    /**
     * Returns the string table for class {@link CommandType}.
     */
    protected String[] getStringTable() {
        return stringTable;
    }

    /**
     * Returns the enumeration value table for class {@link CommandType}.
     */
    protected CommandType[] getEnumValueTable() {
        return enumValueTable;
    }

    /**
     * Return an object of the specified value.
     * @param value a designator for the object.
     */
    public static CommandType getCommandType(int value) {
        return enumValueTable[value];
    }

    /**
     * Return the string name of this {@link CommandType} or the integer value if
     * outside the bounds of the table
     */
    public String toString() {
        if (this.value >= 0 && this.value <= stringTable.length) {
            return stringTable[value];
        } else {
            return String.valueOf(value);
        }
    }

    /**
     * Returns the lowest integer value used by this enumeration value's
     * enumeration class.<br/>
     *
     * The default implementation returns 0. If the enumeration class (a
     * subclass of class EnumSyntax) uses integer values starting at other
     * than 0, override this method in the subclass.
     * @return the offset of the lowest enumeration value.
     */
    protected int getOffset() {
        return 0;
    }
}
