/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DDBeanRoot.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.model;

import javax.enterprise.deploy.shared.ModuleType;

/**
 * An interface that represents the root of a standard deployment descriptor. A
 * DDBeanRoot is a type of DDBean.
 * @author Guillaume Sauthier
 */
public interface DDBeanRoot extends DDBean {

    /**
     * Return the ModuleType of deployment descriptor.
     * @return The ModuleType of deployment descriptor
     */
    ModuleType getType();

    /**
     * Return the containing DeployableObject
     * @return The DeployableObject that contains this deployment descriptor
     */
    DeployableObject getDeployableObject();

    /**
     * A convenience method to return the DTD version number. The DeployableObject
     * has this information.
     * @return a string containing the DTD version number This method is being
     *         deprecated. Two DD data formats are being used, DTD and XML Schema.
     *         DDBeanRoot.getDDBeanRootVersion should be used in its place.
     * @deprecated As of version 1.1 replaced by DDBeanRoot.getDDBeanRootVersion()
     */
    String getModuleDTDVersion();

    /**
     * Returns the version number of an XML instance document. This method is replacing
     * the methods DDBeanRoot.getModuleDTDVersion and DeployableObject.getModuleDTDVersion.
     * This method returns the version number of any J2EE XML instance document.
     * @return a string that is the version number of the XML instance document. Null
     *         is returned if no version number can be found.
     */
    String getDDBeanRootVersion();

    /**
     * Return the XPath for this standard bean. The root XPath is "/".
     * @return "/" this is the root standard bean.
     */
    String getXpath();

    /**
     * Returns the filename relative to the root of the module of the XML instance
     * document this DDBeanRoot represents.
     * @return String the filename relative to the root of the module
     */
    String getFilename();
}
