/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DDBean.java 1520 2007-07-04 22:35:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.model;

/**
 * An interface for beans that represent a fragment of a standard deployment
 * descriptor. A link is provided to the J2EE application that includes this bean.
 * @author Guillaume Sauthier
 */
public interface DDBean {

    /**
     * Returns the original xpath string provided by the DConfigBean.
     * @return The XPath of this Bean.
     */
    String getXpath();

    /**
     * Returns the XML text for by this bean.
     * @return The XML text for this Bean.
     */
    String getText();

    /**
     * Returns a tool-specific reference for attribute ID on an element in the
     * deployment descriptor. This attribute is defined for J2EE 1.2 and 1.3 components.
     * @return The XML text for this Bean or 'null' if no attribute was specified with the tag.
     */
    String getId();

    /**
     * Return the root element for this DDBean.
     * @return The {@link DDBeanRoot} at the root of this DDBean tree.
     */
    DDBeanRoot getRoot();

    /**
     * Return a list of DDBeans based upon the XPath.
     * @param xpath An XPath string referring to a location in the same deployment
     *        descriptor as this standard bean.
     * @return a list of DDBeans or 'null' if no matching XML data is found.
     */
    DDBean[] getChildBean(String xpath);

    /**
     * Return a list of text values for a given XPath in the deployment descriptor.
     * @param xpath An XPath.
     * @return The list text values for this XPath or 'null' if no matching XML data
     *         is found.
     */
    String[] getText(String xpath);

    /**
     * Register a listener for a specific XPath.
     * @param xpath The XPath this listener is to be registered for.
     * @param xpl The listener object.
     */
    void addXpathListener(String xpath,
            XpathListener xpl);

    /**
     * Unregister a listener for a specific XPath.
     * @param xpath The XPath from which this listener is to be unregistered.
     * @param xpl The listener object.
     */
    void removeXpathListener(String xpath,
            XpathListener xpl);

    /**
     * Returns the list of attribute names associated with the XML element.
     * @return a list of attribute names on this element. Null is returned if there are
     *         no attributes.
     */
    String[] getAttributeNames();

    /**
     * Returns the string value of the named attribute.
     * @param attrName attribute name
     * @return a the value of the attribute. Null is returned if there is no such attribute.
     */
    String getAttributeValue(String attrName);


}
