/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.json.impl;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.ow2.chameleon.json.JSONService;
import org.ow2.chameleon.json.JSONXMLService;

public class JSONServiceProvider
implements JSONService,
JSONXMLService,
Pojo {
    private InstanceManager __IM;
    private static final int BUFFER_SIZE = 4096;
    private boolean __MfromXML$java_lang_String;
    private boolean __MfromXML$java_io_InputStream;
    private boolean __MarrayToList$org_json_JSONArray;
    private boolean __MfromJSON$java_lang_String;
    private boolean __MfromJSON$java_io_InputStream;
    private boolean __MgetNull;
    private boolean __MtoJSON$java_util_Map;

    public JSONServiceProvider() {
        this(null);
    }

    private JSONServiceProvider(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String fromXML(String string) throws ParseException {
        String string2;
        if (!this.__MfromXML$java_lang_String) {
            return this.__fromXML(string);
        }
        try {
            this.__IM.onEntry((Object)this, "fromXML$java_lang_String", new Object[]{string});
            string2 = this.__fromXML(string);
            this.__IM.onExit((Object)this, "fromXML$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromXML$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __fromXML(String xml) throws ParseException {
        try {
            JSONObject object = XML.toJSONObject(xml);
            return object.toString();
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public String fromXML(InputStream inputStream) throws ParseException, IOException {
        String string;
        if (!this.__MfromXML$java_io_InputStream) {
            return this.__fromXML(inputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "fromXML$java_io_InputStream", new Object[]{inputStream});
            string = this.__fromXML(inputStream);
            this.__IM.onExit((Object)this, "fromXML$java_io_InputStream", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromXML$java_io_InputStream", throwable);
            throw throwable;
        }
        return string;
    }

    private String __fromXML(InputStream is) throws ParseException, IOException {
        String json = JSONServiceProvider.read(is);
        return this.fromXML(json);
    }

    private List arrayToList(JSONArray jSONArray) throws ParseException, JSONException {
        List list;
        if (!this.__MarrayToList$org_json_JSONArray) {
            return this.__arrayToList(jSONArray);
        }
        try {
            this.__IM.onEntry((Object)this, "arrayToList$org_json_JSONArray", new Object[]{jSONArray});
            list = this.__arrayToList(jSONArray);
            this.__IM.onExit((Object)this, "arrayToList$org_json_JSONArray", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "arrayToList$org_json_JSONArray", throwable);
            throw throwable;
        }
        return list;
    }

    private List __arrayToList(JSONArray array) throws ParseException, JSONException {
        if (array == null || array.length() == 0) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            Object object = array.get(i);
            if (object instanceof JSONObject) {
                list.add(this.fromJSON(object.toString()));
                continue;
            }
            if (object instanceof JSONArray) {
                list.add(this.arrayToList((JSONArray)object));
                continue;
            }
            list.add(object);
        }
        return list;
    }

    public Map fromJSON(String string) throws ParseException {
        Map map;
        if (!this.__MfromJSON$java_lang_String) {
            return this.__fromJSON(string);
        }
        try {
            this.__IM.onEntry((Object)this, "fromJSON$java_lang_String", new Object[]{string});
            map = this.__fromJSON(string);
            this.__IM.onExit((Object)this, "fromJSON$java_lang_String", (Object)map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromJSON$java_lang_String", throwable);
            throw throwable;
        }
        return map;
    }

    private Map __fromJSON(String json) throws ParseException {
        if (json == null || json.length() == 0) {
            return new HashMap();
        }
        try {
            JSONObject object = new JSONObject(json);
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator iterator = object.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object obj = object.get(key);
                if (obj instanceof JSONArray) {
                    map.put(key, this.arrayToList((JSONArray)obj));
                    continue;
                }
                if (obj instanceof JSONObject) {
                    Map inner = this.fromJSON(obj.toString());
                    map.put(key, inner);
                    continue;
                }
                map.put(key, obj);
            }
            return map;
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public Map fromJSON(InputStream inputStream) throws ParseException, IOException {
        Map map;
        if (!this.__MfromJSON$java_io_InputStream) {
            return this.__fromJSON(inputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "fromJSON$java_io_InputStream", new Object[]{inputStream});
            map = this.__fromJSON(inputStream);
            this.__IM.onExit((Object)this, "fromJSON$java_io_InputStream", (Object)map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "fromJSON$java_io_InputStream", throwable);
            throw throwable;
        }
        return map;
    }

    private Map __fromJSON(InputStream is) throws ParseException, IOException {
        if (is == null) {
            return new HashMap();
        }
        String json = JSONServiceProvider.read(is);
        return this.fromJSON(json);
    }

    public Object getNull() {
        Object object;
        if (!this.__MgetNull) {
            return this.__getNull();
        }
        try {
            this.__IM.onEntry((Object)this, "getNull", new Object[0]);
            object = this.__getNull();
            this.__IM.onExit((Object)this, "getNull", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNull", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __getNull() {
        return JSONObject.NULL;
    }

    public static String read(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public String toJSON(Map map) {
        String string;
        if (!this.__MtoJSON$java_util_Map) {
            return this.__toJSON(map);
        }
        try {
            this.__IM.onEntry((Object)this, "toJSON$java_util_Map", new Object[]{map});
            string = this.__toJSON(map);
            this.__IM.onExit((Object)this, "toJSON$java_util_Map", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toJSON$java_util_Map", throwable);
            throw throwable;
        }
        return string;
    }

    private String __toJSON(Map map) {
        JSONObject json = new JSONObject(map);
        return json.toString();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("fromXML$java_lang_String")) {
                this.__MfromXML$java_lang_String = true;
            }
            if (set.contains("fromXML$java_io_InputStream")) {
                this.__MfromXML$java_io_InputStream = true;
            }
            if (set.contains("arrayToList$org_json_JSONArray")) {
                this.__MarrayToList$org_json_JSONArray = true;
            }
            if (set.contains("fromJSON$java_lang_String")) {
                this.__MfromJSON$java_lang_String = true;
            }
            if (set.contains("fromJSON$java_io_InputStream")) {
                this.__MfromJSON$java_io_InputStream = true;
            }
            if (set.contains("getNull")) {
                this.__MgetNull = true;
            }
            if (set.contains("toJSON$java_util_Map")) {
                this.__MtoJSON$java_util_Map = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

