/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.functions;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.h2.tools.SimpleResultSet;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;
import org.h2gis.api.ScalarFunction;
import org.h2gis.network.functions.GraphFunction;
import org.h2gis.network.functions.GraphFunctionParser;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableUtilities;
import org.javanetworkanalyzer.alg.Dijkstra;
import org.javanetworkanalyzer.data.VDijkstra;
import org.javanetworkanalyzer.model.Edge;
import org.javanetworkanalyzer.model.KeyedGraph;
import org.jgrapht.Graph;

public class ST_ShortestPathLength
extends GraphFunction
implements ScalarFunction {
    public static final int SOURCE_INDEX = 1;
    public static final int DESTINATION_INDEX = 2;
    public static final int DISTANCE_INDEX = 3;
    public static final String REMARKS = "`ST_ShortestPathLength` calculates the length(s) of shortest path(s) among\nvertices in a graph. Possible signatures:\n* `ST_ShortestPathLength('input_edges', 'o[ - eo]', s)` - One-to-All\n* `ST_ShortestPathLength('input_edges', 'o[ - eo]', 'sdt')` - Many-to-Many\n* `ST_ShortestPathLength('input_edges', 'o[ - eo]', s, d)` - One-to-One\n* `ST_ShortestPathLength('input_edges', 'o[ - eo]', s, 'ds')` - One-to-Several\n* `ST_ShortestPathLength('input_edges', 'o[ - eo]', 'w', s)` - One-to-All weighted\n* `ST_ShortestPathLength('input_edges', 'o[ - eo]', 'w', 'sdt')` - Many-to-Many weighted\n* `ST_ShortestPathLength('input_edges', 'o[ - eo]', 'w', s, d)` - One-to-One weighted\n* `ST_ShortestPathLength('input_edges', 'o[ - eo]', 'w', s, 'ds')` - One-to-Several weighted\n\nwhere\n* `input_edges` = Edges table produced by `ST_Graph` from table `input`\n* `o` = Global orientation (directed, reversed or undirected)\n* `eo` = Edge orientation (1 = directed, -1 = reversed, 0 = undirected).\n  Required if global orientation is directed or reversed.\n* `w` = Name of column containing edge weights as doubles\n* `s` = Source vertex id\n* `d` = Destination vertex id\n* `sdt` = Source-Destination table name (must contain columns\n  SOURCE and DESTINATION containing integer vertex ids)\n* `ds` = Comma-separated Destination string ('dest1, dest2, ...')\n";

    public ST_ShortestPathLength() {
        this.addProperty("remarks", REMARKS);
    }

    public String getJavaStaticMethod() {
        return "getShortestPathLength";
    }

    public static ResultSet getShortestPathLength(Connection connection, String inputTable, String orientation, Value arg3) throws SQLException {
        if (TableUtilities.isColumnListConnection((Connection)connection)) {
            return ST_ShortestPathLength.prepareResultSet();
        }
        if (arg3 instanceof ValueInt) {
            int source = arg3.getInt();
            return ST_ShortestPathLength.oneToAll(connection, inputTable, orientation, null, source);
        }
        if (arg3 instanceof ValueString) {
            String table = arg3.getString();
            return ST_ShortestPathLength.manyToMany(connection, inputTable, orientation, null, table);
        }
        throw new IllegalArgumentException("Unrecognized argument: " + arg3);
    }

    public static ResultSet getShortestPathLength(Connection connection, String inputTable, String orientation, Value arg3, Value arg4) throws SQLException {
        if (TableUtilities.isColumnListConnection((Connection)connection)) {
            return ST_ShortestPathLength.prepareResultSet();
        }
        if (arg3 instanceof ValueInt) {
            int source = arg3.getInt();
            if (arg4 instanceof ValueInt) {
                int destination = arg4.getInt();
                return ST_ShortestPathLength.oneToOne(connection, inputTable, orientation, null, source, destination);
            }
            if (arg4 instanceof ValueString) {
                String destinationString = arg4.getString();
                return ST_ShortestPathLength.oneToSeveral(connection, inputTable, orientation, null, source, destinationString);
            }
            throw new IllegalArgumentException("Unrecognized argument: " + arg4);
        }
        if (arg3 instanceof ValueString) {
            String arg3String = arg3.getString();
            if (JDBCUtilities.hasField((Connection)connection, (String)inputTable, (String)arg3String)) {
                String weight = arg3String;
                if (arg4 instanceof ValueInt) {
                    int source = arg4.getInt();
                    return ST_ShortestPathLength.oneToAll(connection, inputTable, orientation, weight, source);
                }
                if (arg4 instanceof ValueString) {
                    String table = arg4.getString();
                    return ST_ShortestPathLength.manyToMany(connection, inputTable, orientation, weight, table);
                }
                throw new IllegalArgumentException("Unrecognized argument: " + arg4);
            }
            String sourceTable = arg3String;
            if (arg4 instanceof ValueString) {
                String destTable = arg4.getString();
                return ST_ShortestPathLength.manyToManySeparateTables(connection, inputTable, orientation, null, sourceTable, destTable);
            }
            throw new IllegalArgumentException("Unrecognized argument: " + arg4);
        }
        throw new IllegalArgumentException("Unrecognized argument: " + arg3);
    }

    public static ResultSet getShortestPathLength(Connection connection, String inputTable, String orientation, String weight, Value arg4, Value arg5) throws SQLException {
        if (TableUtilities.isColumnListConnection((Connection)connection)) {
            return ST_ShortestPathLength.prepareResultSet();
        }
        if (arg4 instanceof ValueInt) {
            int source = arg4.getInt();
            if (arg5 instanceof ValueInt) {
                int destination = arg5.getInt();
                return ST_ShortestPathLength.oneToOne(connection, inputTable, orientation, weight, source, destination);
            }
            if (arg5 instanceof ValueString) {
                String destinationString = arg5.getString();
                return ST_ShortestPathLength.oneToSeveral(connection, inputTable, orientation, weight, source, destinationString);
            }
            throw new IllegalArgumentException("Unrecognized argument: " + arg5);
        }
        if (arg4 instanceof ValueString) {
            String sourceTable = arg4.getString();
            if (arg5 instanceof ValueString) {
                String destTable = arg5.getString();
                return ST_ShortestPathLength.manyToManySeparateTables(connection, inputTable, orientation, weight, sourceTable, destTable);
            }
            throw new IllegalArgumentException("Unrecognized argument: " + arg4);
        }
        throw new IllegalArgumentException("Unrecognized argument: " + arg4);
    }

    private static ResultSet oneToOne(Connection connection, String inputTable, String orientation, String weight, int source, int destination) throws SQLException {
        SimpleResultSet output = ST_ShortestPathLength.prepareResultSet();
        KeyedGraph graph = ST_ShortestPathLength.prepareGraph(connection, inputTable, orientation, weight, VDijkstra.class, Edge.class);
        double distance = new Dijkstra((Graph)graph).oneToOne((VDijkstra)graph.getVertex(source), (VDijkstra)graph.getVertex(destination));
        output.addRow(new Object[]{source, destination, distance});
        return output;
    }

    private static ResultSet oneToAll(Connection connection, String inputTable, String orientation, String weight, int source) throws SQLException {
        SimpleResultSet output = ST_ShortestPathLength.prepareResultSet();
        KeyedGraph graph = ST_ShortestPathLength.prepareGraph(connection, inputTable, orientation, weight, VDijkstra.class, Edge.class);
        Map distances = new Dijkstra((Graph)graph).oneToMany((VDijkstra)graph.getVertex(source), graph.vertexSet());
        for (Map.Entry e : distances.entrySet()) {
            output.addRow(new Object[]{source, ((VDijkstra)e.getKey()).getID(), e.getValue()});
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResultSet manyToMany(Connection connection, String inputTable, String orientation, String weight, String sourceDestinationTable) throws SQLException {
        SimpleResultSet output = ST_ShortestPathLength.prepareResultSet();
        KeyedGraph graph = ST_ShortestPathLength.prepareGraph(connection, inputTable, orientation, weight, VDijkstra.class, Edge.class);
        Statement st = connection.createStatement();
        try {
            Map<VDijkstra, Set<VDijkstra>> sourceDestinationMap = ST_ShortestPathLength.prepareSourceDestinationMap(st, sourceDestinationTable, (KeyedGraph<VDijkstra, Edge>)graph);
            Dijkstra dijkstra = new Dijkstra((Graph)graph);
            for (Map.Entry<VDijkstra, Set<VDijkstra>> sourceToDestSetMap : sourceDestinationMap.entrySet()) {
                Map distances = dijkstra.oneToMany(sourceToDestSetMap.getKey(), sourceToDestSetMap.getValue());
                for (Map.Entry destToDistMap : distances.entrySet()) {
                    output.addRow(new Object[]{sourceToDestSetMap.getKey().getID(), ((VDijkstra)destToDistMap.getKey()).getID(), destToDistMap.getValue()});
                }
            }
        }
        finally {
            st.close();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResultSet manyToManySeparateTables(Connection connection, String inputTable, String orientation, String weight, String sourceTable, String destTable) throws SQLException {
        SimpleResultSet output = ST_ShortestPathLength.prepareResultSet();
        KeyedGraph graph = ST_ShortestPathLength.prepareGraph(connection, inputTable, orientation, weight, VDijkstra.class, Edge.class);
        Statement st = connection.createStatement();
        try {
            Set<VDijkstra> destSet = ST_ShortestPathLength.getSet(st, (KeyedGraph<VDijkstra, Edge>)graph, destTable);
            Set<VDijkstra> sourceSet = ST_ShortestPathLength.getSet(st, (KeyedGraph<VDijkstra, Edge>)graph, sourceTable);
            Dijkstra dijkstra = new Dijkstra((Graph)graph);
            for (VDijkstra source : sourceSet) {
                Map distances = dijkstra.oneToMany(source, destSet);
                for (Map.Entry destToDistMap : distances.entrySet()) {
                    output.addRow(new Object[]{source.getID(), ((VDijkstra)destToDistMap.getKey()).getID(), destToDistMap.getValue()});
                }
            }
        }
        finally {
            st.close();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<VDijkstra> getSet(Statement st, KeyedGraph<VDijkstra, Edge> graph, String tableName) throws SQLException {
        ResultSet intSet = st.executeQuery("SELECT * FROM " + tableName);
        try {
            HashSet<VDijkstra> set = new HashSet<VDijkstra>();
            while (intSet.next()) {
                int vertexID = intSet.getInt(1);
                VDijkstra vertex = (VDijkstra)graph.getVertex(vertexID);
                if (vertex == null) {
                    throw new IllegalArgumentException("The graph does not contain vertex " + vertexID);
                }
                set.add(vertex);
            }
            if (set.isEmpty()) {
                throw new IllegalArgumentException("Table " + tableName + " was empty.");
            }
            HashSet<VDijkstra> hashSet = set;
            return hashSet;
        }
        finally {
            intSet.close();
        }
    }

    private static ResultSet oneToSeveral(Connection connection, String inputTable, String orientation, String weight, int source, String destString) throws SQLException {
        SimpleResultSet output = ST_ShortestPathLength.prepareResultSet();
        KeyedGraph graph = ST_ShortestPathLength.prepareGraph(connection, inputTable, orientation, weight, VDijkstra.class, Edge.class);
        int[] destIDs = GraphFunctionParser.parseDestinationsString(destString);
        HashSet<VDijkstra> destSet = new HashSet<VDijkstra>();
        for (int d : destIDs) {
            VDijkstra dest = (VDijkstra)graph.getVertex(d);
            if (dest == null) {
                throw new IllegalArgumentException("The graph does not contain vertex " + d);
            }
            destSet.add(dest);
        }
        Map distances = new Dijkstra((Graph)graph).oneToMany((VDijkstra)graph.getVertex(source), destSet);
        for (Map.Entry e : distances.entrySet()) {
            output.addRow(new Object[]{source, ((VDijkstra)e.getKey()).getID(), e.getValue()});
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<VDijkstra, Set<VDijkstra>> prepareSourceDestinationMap(Statement st, String sourceDestinationTable, KeyedGraph<VDijkstra, Edge> graph) throws SQLException {
        ResultSet sourceDestinationRS = st.executeQuery("SELECT SOURCE, DESTINATION FROM " + sourceDestinationTable);
        try {
            HashMap<VDijkstra, Set<VDijkstra>> map = new HashMap<VDijkstra, Set<VDijkstra>>();
            while (sourceDestinationRS.next()) {
                VDijkstra source = (VDijkstra)graph.getVertex(sourceDestinationRS.getInt(1));
                VDijkstra destination = (VDijkstra)graph.getVertex(sourceDestinationRS.getInt(2));
                HashSet<VDijkstra> targets = (HashSet<VDijkstra>)map.get(source);
                if (targets == null) {
                    targets = new HashSet<VDijkstra>();
                    map.put(source, targets);
                }
                targets.add(destination);
            }
            if (map.isEmpty()) {
                throw new IllegalArgumentException("No sources/destinations requested.");
            }
            HashMap<VDijkstra, Set<VDijkstra>> hashMap = map;
            return hashMap;
        }
        finally {
            sourceDestinationRS.close();
        }
    }

    private static SimpleResultSet prepareResultSet() {
        SimpleResultSet output = new SimpleResultSet();
        output.addColumn("SOURCE", 4, 10, 0);
        output.addColumn("DESTINATION", 4, 10, 0);
        output.addColumn("DISTANCE", 8, 10, 0);
        return output;
    }
}

