/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.functions;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.h2.tools.SimpleResultSet;
import org.h2gis.api.ScalarFunction;
import org.h2gis.network.functions.GraphFunction;
import org.h2gis.network.functions.GraphFunctionParser;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.javanetworkanalyzer.analyzers.AccessibilityAnalyzer;
import org.javanetworkanalyzer.data.VAccess;
import org.javanetworkanalyzer.model.Edge;
import org.javanetworkanalyzer.model.KeyedGraph;

public class ST_Accessibility
extends GraphFunction
implements ScalarFunction {
    public static final String REMARKS = "`ST_Accessibility` calculates, for each vertex in a graph, the closest\ndestination among several possible destinations as well as the distance to this\ndestination. Possible signatures: \n* `ST_Accessibility('input_edges', 'o[ - eo]', 'ds')`\n* `ST_Accessibility('input_edges', 'o[ - eo]', 'dt')`\n* `ST_Accessibility('input_edges', 'o[ - eo]', 'w', 'ds')`\n* `ST_Accessibility('input_edges', 'o[ - eo]', 'w', 'dt')` \n\nwhere \n* `input_edges` = Edges table produced by `ST_Graph` from table `input`\n* `o` = Global orientation (directed, reversed or undirected)\n* `eo` = Edge orientation (1 = directed, -1 = reversed, 0 = undirected).\n  Required if global orientation is directed or reversed.\n* `w` = Name of column containing edge weights as doubles\n* `ds` = Comma-separated Destination string ('dest1, dest2, ...')\n* `dt` = Destination table name (must contain column containing integer vertex\n  ids)\n";

    public ST_Accessibility() {
        this.addProperty("remarks", REMARKS);
    }

    public String getJavaStaticMethod() {
        return "getAccessibility";
    }

    public static ResultSet getAccessibility(Connection connection, String inputTable, String orientation, String arg3) throws SQLException {
        return ST_Accessibility.getAccessibility(connection, inputTable, orientation, null, arg3);
    }

    public static ResultSet getAccessibility(Connection connection, String inputTable, String orientation, String weight, String arg4) throws SQLException {
        if (TableUtilities.isColumnListConnection((Connection)connection)) {
            return ST_Accessibility.prepareResultSet();
        }
        KeyedGraph graph = ST_Accessibility.prepareGraph(connection, inputTable, orientation, weight, VAccess.class, Edge.class);
        if (GraphFunctionParser.isDestinationsString(arg4)) {
            return ST_Accessibility.compute((KeyedGraph<VAccess, Edge>)graph, ST_Accessibility.prepareDestSet((KeyedGraph<VAccess, Edge>)graph, GraphFunctionParser.parseDestinationsString(arg4)));
        }
        return ST_Accessibility.compute((KeyedGraph<VAccess, Edge>)graph, ST_Accessibility.prepareDestSet(connection, (KeyedGraph<VAccess, Edge>)graph, arg4));
    }

    private static ResultSet compute(KeyedGraph<VAccess, Edge> graph, Set<VAccess> destinations) throws SQLException {
        SimpleResultSet output = ST_Accessibility.prepareResultSet();
        new AccessibilityAnalyzer(graph, destinations).compute();
        for (VAccess v : graph.vertexSet()) {
            output.addRow(new Object[]{v.getID(), v.getClosestDestinationId(), v.getDistanceToClosestDestination()});
        }
        return output;
    }

    private static Set<VAccess> prepareDestSet(KeyedGraph<VAccess, Edge> graph, int[] dests) {
        HashSet<VAccess> destinations = new HashSet<VAccess>();
        for (int i = 0; i < dests.length; ++i) {
            destinations.add((VAccess)graph.getVertex(dests[i]));
        }
        return destinations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<VAccess> prepareDestSet(Connection connection, KeyedGraph<VAccess, Edge> graph, String destTable) throws SQLException {
        Statement st = connection.createStatement();
        HashSet<VAccess> destinations = new HashSet<VAccess>();
        try {
            TableLocation destinationTable = TableUtilities.parseInputTable((Connection)connection, (String)destTable);
            ResultSet rs = st.executeQuery("SELECT DESTINATION FROM " + destinationTable);
            while (rs.next()) {
                destinations.add((VAccess)graph.getVertex(rs.getInt(1)));
            }
        }
        finally {
            st.close();
        }
        return destinations;
    }

    private static SimpleResultSet prepareResultSet() {
        SimpleResultSet output = new SimpleResultSet();
        output.addColumn("SOURCE", 4, 10, 0);
        output.addColumn("CLOSEST_DEST", 4, 10, 0);
        output.addColumn("DISTANCE", 8, 10, 0);
        return output;
    }
}

