/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.volume;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import org.h2gis.functions.spatial.edit.ST_UpdateZ;

public class GeometryExtrude {
    private GeometryExtrude() {
    }

    public static GeometryCollection extrudePolygonAsGeometry(Polygon polygon, double height) {
        GeometryFactory factory = polygon.getFactory();
        Geometry[] geometries = new Geometry[3];
        LineString shell = GeometryExtrude.getClockWise(polygon.getExteriorRing());
        ArrayList<Polygon> walls = new ArrayList<Polygon>();
        for (int i = 1; i < shell.getNumPoints(); ++i) {
            walls.add(GeometryExtrude.extrudeEdge(shell.getCoordinateN(i - 1), shell.getCoordinateN(i), height, factory));
        }
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            LineString hole = GeometryExtrude.getCounterClockWise(polygon.getInteriorRingN(i));
            for (int j = 1; j < hole.getNumPoints(); ++j) {
                walls.add(GeometryExtrude.extrudeEdge(hole.getCoordinateN(j - 1), hole.getCoordinateN(j), height, factory));
            }
            holes[i] = factory.createLinearRing(hole.getCoordinateSequence());
        }
        geometries[0] = factory.createPolygon(factory.createLinearRing(shell.getCoordinateSequence()), holes);
        geometries[1] = factory.createMultiPolygon(walls.toArray(new Polygon[walls.size()]));
        geometries[2] = GeometryExtrude.extractRoof(polygon, height);
        return polygon.getFactory().createGeometryCollection(geometries);
    }

    public static GeometryCollection extrudeLineStringAsGeometry(LineString lineString, double height) {
        Geometry[] geometries = new Geometry[3];
        GeometryFactory factory = lineString.getFactory();
        Coordinate[] coords = lineString.getCoordinates();
        Polygon[] walls = new Polygon[coords.length - 1];
        for (int i = 0; i < coords.length - 1; ++i) {
            walls[i] = GeometryExtrude.extrudeEdge(coords[i], coords[i + 1], height, factory);
        }
        lineString.apply((CoordinateSequenceFilter)new TranslateCoordinateSequenceFilter(0.0));
        geometries[0] = lineString;
        geometries[1] = factory.createMultiPolygon(walls);
        geometries[2] = GeometryExtrude.extractRoof(lineString, height);
        return factory.createGeometryCollection(geometries);
    }

    public static Geometry extractRoof(LineString lineString, double height) {
        LineString result = (LineString)lineString.clone();
        result.apply((CoordinateSequenceFilter)new TranslateCoordinateSequenceFilter(height));
        return result;
    }

    public static MultiPolygon extractWalls(Polygon polygon, double height) {
        GeometryFactory factory = polygon.getFactory();
        LineString shell = GeometryExtrude.getClockWise(polygon.getExteriorRing());
        ArrayList<Polygon> walls = new ArrayList<Polygon>();
        for (int i = 1; i < shell.getNumPoints(); ++i) {
            walls.add(GeometryExtrude.extrudeEdge(shell.getCoordinateN(i - 1), shell.getCoordinateN(i), height, factory));
        }
        int nbOfHoles = polygon.getNumInteriorRing();
        for (int i = 0; i < nbOfHoles; ++i) {
            LineString hole = GeometryExtrude.getCounterClockWise(polygon.getInteriorRingN(i));
            for (int j = 1; j < hole.getNumPoints(); ++j) {
                walls.add(GeometryExtrude.extrudeEdge(hole.getCoordinateN(j - 1), hole.getCoordinateN(j), height, factory));
            }
        }
        return polygon.getFactory().createMultiPolygon(walls.toArray(new Polygon[walls.size()]));
    }

    public static Polygon extractRoof(Polygon polygon, double height) {
        GeometryFactory factory = polygon.getFactory();
        Polygon roofP = (Polygon)polygon.clone();
        roofP.apply((CoordinateSequenceFilter)new TranslateCoordinateSequenceFilter(height));
        LinearRing shell = factory.createLinearRing(GeometryExtrude.getCounterClockWise(roofP.getExteriorRing()).getCoordinates());
        int nbOfHoles = roofP.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = factory.createLinearRing(GeometryExtrude.getClockWise(roofP.getInteriorRingN(i)).getCoordinates());
        }
        return factory.createPolygon(shell, holes);
    }

    public static MultiPolygon extractWalls(LineString lineString, double height) {
        GeometryFactory factory = lineString.getFactory();
        Coordinate[] coords = lineString.getCoordinates();
        Polygon[] walls = new Polygon[coords.length - 1];
        for (int i = 0; i < coords.length - 1; ++i) {
            walls[i] = GeometryExtrude.extrudeEdge(coords[i], coords[i + 1], height, factory);
        }
        return lineString.getFactory().createMultiPolygon(walls);
    }

    private static LineString getClockWise(LineString lineString) {
        Coordinate c0 = lineString.getCoordinateN(0);
        Coordinate c1 = lineString.getCoordinateN(1);
        Coordinate c2 = lineString.getCoordinateN(2);
        lineString.apply((CoordinateSequenceFilter)new ST_UpdateZ.UpdateZCoordinateSequenceFilter(0.0, 3));
        if (CGAlgorithms.computeOrientation((Coordinate)c0, (Coordinate)c1, (Coordinate)c2) == -1) {
            return lineString;
        }
        return (LineString)lineString.reverse();
    }

    private static LineString getCounterClockWise(LineString lineString) {
        Coordinate c0 = lineString.getCoordinateN(0);
        Coordinate c1 = lineString.getCoordinateN(1);
        Coordinate c2 = lineString.getCoordinateN(2);
        lineString.apply((CoordinateSequenceFilter)new ST_UpdateZ.UpdateZCoordinateSequenceFilter(0.0, 3));
        if (CGAlgorithms.computeOrientation((Coordinate)c0, (Coordinate)c1, (Coordinate)c2) == 1) {
            return lineString;
        }
        return (LineString)lineString.reverse();
    }

    private static Polygon extractFloor(Polygon polygon) {
        GeometryFactory factory = polygon.getFactory();
        LinearRing shell = factory.createLinearRing(GeometryExtrude.getClockWise(polygon.getExteriorRing()).getCoordinates());
        int nbOfHoles = polygon.getNumInteriorRing();
        LinearRing[] holes = new LinearRing[nbOfHoles];
        for (int i = 0; i < nbOfHoles; ++i) {
            holes[i] = factory.createLinearRing(GeometryExtrude.getCounterClockWise(polygon.getInteriorRingN(i)).getCoordinates());
        }
        return factory.createPolygon(shell, holes);
    }

    private static Polygon extrudeEdge(Coordinate beginPoint, Coordinate endPoint, double height, GeometryFactory factory) {
        beginPoint.z = Double.isNaN(beginPoint.z) ? 0.0 : beginPoint.z;
        endPoint.z = Double.isNaN(endPoint.z) ? 0.0 : endPoint.z;
        return factory.createPolygon(new Coordinate[]{beginPoint, new Coordinate(beginPoint.x, beginPoint.y, beginPoint.z + height), new Coordinate(endPoint.x, endPoint.y, endPoint.z + height), endPoint, beginPoint});
    }

    public static class TranslateCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private boolean done = false;
        private final double z;

        public TranslateCoordinateSequenceFilter(double z) {
            this.z = z;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void filter(CoordinateSequence seq, int i) {
            Coordinate coord = seq.getCoordinate(i);
            double currentZ = coord.z;
            if (!Double.isNaN(currentZ)) {
                seq.setOrdinate(i, 2, currentZ + this.z);
            } else {
                seq.setOrdinate(i, 2, this.z);
            }
            if (i == seq.size()) {
                this.done = true;
            }
        }
    }
}

