/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_RemoveRepeatedPoints
extends DeterministicScalarFunction {
    private static final GeometryFactory FACTORY = new GeometryFactory();

    public ST_RemoveRepeatedPoints() {
        this.addProperty("remarks", "Returns a version of the given geometry with duplicated points removed.");
    }

    public String getJavaStaticMethod() {
        return "removeRepeatedPoints";
    }

    public static Geometry removeRepeatedPoints(Geometry geometry) {
        return ST_RemoveRepeatedPoints.removeDuplicateCoordinates(geometry);
    }

    public static Geometry removeDuplicateCoordinates(Geometry geom) {
        if (geom == null) {
            return null;
        }
        if (geom.isEmpty()) {
            return geom;
        }
        if (geom instanceof Point || geom instanceof MultiPoint) {
            return geom;
        }
        if (geom instanceof LineString) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((MultiPolygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            return ST_RemoveRepeatedPoints.removeDuplicateCoordinates((GeometryCollection)geom);
        }
        return null;
    }

    public static LineString removeDuplicateCoordinates(LineString g) {
        Coordinate[] coords = CoordinateArrays.removeRepeatedPoints((Coordinate[])g.getCoordinates());
        return FACTORY.createLineString(coords);
    }

    public static LinearRing removeDuplicateCoordinates(LinearRing g) {
        Coordinate[] coords = CoordinateArrays.removeRepeatedPoints((Coordinate[])g.getCoordinates());
        return FACTORY.createLinearRing(coords);
    }

    public static MultiLineString removeDuplicateCoordinates(MultiLineString g) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            LineString line = (LineString)g.getGeometryN(i);
            lines.add(ST_RemoveRepeatedPoints.removeDuplicateCoordinates(line));
        }
        return FACTORY.createMultiLineString(GeometryFactory.toLineStringArray(lines));
    }

    public static Polygon removeDuplicateCoordinates(Polygon poly) {
        Coordinate[] shellCoords = CoordinateArrays.removeRepeatedPoints((Coordinate[])poly.getExteriorRing().getCoordinates());
        LinearRing shell = FACTORY.createLinearRing(shellCoords);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            Coordinate[] holeCoords = CoordinateArrays.removeRepeatedPoints((Coordinate[])poly.getInteriorRingN(i).getCoordinates());
            holes.add(FACTORY.createLinearRing(holeCoords));
        }
        return FACTORY.createPolygon(shell, GeometryFactory.toLinearRingArray(holes));
    }

    public static MultiPolygon removeDuplicateCoordinates(MultiPolygon g) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)g.getGeometryN(i);
            polys.add(ST_RemoveRepeatedPoints.removeDuplicateCoordinates(poly));
        }
        return FACTORY.createMultiPolygon(GeometryFactory.toPolygonArray(polys));
    }

    public static GeometryCollection removeDuplicateCoordinates(GeometryCollection g) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Geometry geom = g.getGeometryN(i);
            geoms.add(ST_RemoveRepeatedPoints.removeDuplicateCoordinates(geom));
        }
        return FACTORY.createGeometryCollection(GeometryFactory.toGeometryArray(geoms));
    }
}

