/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_Expand
extends DeterministicScalarFunction {
    public ST_Expand() {
        this.addProperty("remarks", "Expands a geometry's envelope by the given delta X and delta Y.\n Both positive and negative distances are supported.");
    }

    public String getJavaStaticMethod() {
        return "expand";
    }

    public static Geometry expand(Geometry geometry, double deltaX, double deltaY) {
        if (geometry == null) {
            return null;
        }
        Envelope env = geometry.getEnvelopeInternal();
        double minX = env.getMinX() - deltaX;
        double maxX = env.getMaxX() + deltaX;
        double minY = env.getMinY() - deltaY;
        double maxY = env.getMaxY() + deltaY;
        Envelope expandedEnvelope = new Envelope(minX < maxX ? minX : (env.getMaxX() - env.getMinX()) / 2.0 + env.getMinX(), minX < maxX ? maxX : (env.getMaxX() - env.getMinX()) / 2.0 + env.getMinX(), minY < maxY ? minY : (env.getMaxY() - env.getMinY()) / 2.0 + env.getMinY(), minY < maxY ? maxY : (env.getMaxY() - env.getMinY()) / 2.0 + env.getMinY());
        return geometry.getFactory().toGeometry(expandedEnvelope);
    }
}

