/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.convert.ST_GeomFromText;

public class ST_LineFromText
extends DeterministicScalarFunction {
    public ST_LineFromText() {
        this.addProperty("remarks", "Convert a WKT String into a LINESTRING.\n If an SRID is not specified, it defaults to 0.");
    }

    public String getJavaStaticMethod() {
        return "toGeometry";
    }

    public static Geometry toGeometry(String wKT) throws SQLException {
        return ST_LineFromText.toGeometry(wKT, 0);
    }

    public static Geometry toGeometry(String wKT, int srid) throws SQLException {
        if (wKT == null) {
            return null;
        }
        Geometry geometry = ST_GeomFromText.toGeometry(wKT, srid);
        if (!geometry.getGeometryType().equalsIgnoreCase("linestring")) {
            throw new SQLException("The provided WKT Geometry is not a LINESTRING.");
        }
        return geometry;
    }
}

