/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.buffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_SideBuffer
extends DeterministicScalarFunction {
    public ST_SideBuffer() {
        this.addProperty("remarks", "Return a buffer at a given distance on only one side of each input lines of the geometry.\nThe optional third parameter can either specify number of segments used\n to approximate a quarter circle (integer case, defaults to 8)\n or a list of blank-separated key=value pairs (string case) to manage line style parameters :\n'quad_segs=8' 'join=round|mitre|bevel' 'mitre_limit=5'\nThe end cap style for single-sided buffers is always ignored, and forced to the equivalent of flat.");
    }

    public String getJavaStaticMethod() {
        return "singleSideBuffer";
    }

    public static Geometry singleSideBuffer(Geometry geometry, double distance) {
        return ST_SideBuffer.computeSingleSideBuffer(geometry, distance, new BufferParameters());
    }

    public static Geometry singleSideBuffer(Geometry geometry, double distance, String parameters) {
        if (geometry == null) {
            return null;
        }
        String[] buffParemeters = parameters.split("\\s+");
        BufferParameters bufferParameters = new BufferParameters();
        for (String params : buffParemeters) {
            String[] keyValue = params.split("=");
            if (keyValue[0].equalsIgnoreCase("join")) {
                String param = keyValue[1];
                if (param.equalsIgnoreCase("bevel")) {
                    bufferParameters.setJoinStyle(3);
                    continue;
                }
                if (param.equalsIgnoreCase("mitre") || param.equalsIgnoreCase("miter")) {
                    bufferParameters.setJoinStyle(2);
                    continue;
                }
                if (param.equalsIgnoreCase("round")) {
                    bufferParameters.setJoinStyle(1);
                    continue;
                }
                throw new IllegalArgumentException("Supported join values are bevel, mitre, miter or round.");
            }
            if (keyValue[0].equalsIgnoreCase("mitre_limit") || keyValue[0].equalsIgnoreCase("miter_limit")) {
                bufferParameters.setMitreLimit(Double.valueOf(keyValue[1]).doubleValue());
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("quad_segs")) {
                bufferParameters.setQuadrantSegments(Integer.valueOf(keyValue[1]).intValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown parameters. Please read the documentation.");
        }
        return ST_SideBuffer.computeSingleSideBuffer(geometry, distance, bufferParameters);
    }

    private static Geometry computeSingleSideBuffer(Geometry geometry, double distance, BufferParameters bufferParameters) {
        bufferParameters.setSingleSided(true);
        return BufferOp.bufferOp((Geometry)geometry, (double)distance, (BufferParameters)bufferParameters);
    }
}

