/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.URIUtilities;

public class ST_OSMDownloader
extends DeterministicScalarFunction {
    private static final String OSM_API_URL = "http://api.openstreetmap.org/api/0.6/";

    public ST_OSMDownloader() {
        this.addProperty("remarks", "Extract an OSM XML file from the OSM api server using a the bounding box of a given geometry.\nA path must be set to specified where the OSM file will be stored.");
    }

    public String getJavaStaticMethod() {
        return "downloadData";
    }

    public static void downloadData(Geometry area, String fileName) throws FileNotFoundException, IOException, SQLException {
        File file = URIUtilities.fileFromString((String)fileName);
        if (file.exists()) {
            throw new FileNotFoundException("The following file already exists:\n" + fileName);
        }
        if (file.getName().toLowerCase().endsWith(".osm")) {
            if (area != null) {
                ST_OSMDownloader.downloadOSMFile(file, area.getEnvelopeInternal());
            }
        } else {
            throw new SQLException("Supported formats are .osm, .osm.gz, .osm.bz2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadOSMFile(File file, Envelope geometryEnvelope) throws IOException {
        InputStream in = ST_OSMDownloader.createOsmUrl(geometryEnvelope).openStream();
        FileOutputStream out = new FileOutputStream(file);
        try {
            int numBytes;
            byte[] data = new byte[4096];
            while ((numBytes = in.read(data)) != -1) {
                ((OutputStream)out).write(data, 0, numBytes);
            }
        }
        finally {
            ((OutputStream)out).close();
            in.close();
        }
    }

    private static URL createOsmUrl(Envelope geometryEnvelope) {
        try {
            return new URL("http://api.openstreetmap.org/api/0.6/map?bbox=" + geometryEnvelope.getMinX() + "," + geometryEnvelope.getMinY() + "," + geometryEnvelope.getMaxX() + "," + geometryEnvelope.getMaxY());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

