/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.kml;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.io.kml.ExtrudeMode;
import org.h2gis.functions.io.kml.KMLGeometry;

public class ST_AsKml
extends DeterministicScalarFunction {
    public ST_AsKml() {
        this.addProperty("remarks", "Return the geometry as a Keyhole Markup Language (KML) element.\nNote this function supports two arguments : extrude (boolean) and altitude mode (integer).\nAvailable extrude values are true, false or none.\nSupported altitude mode :\nFor KML profil : CLAMPTOGROUND = 1; RELATIVETOGROUND = 2; ABSOLUTE = 4;\nFor GX profil : CLAMPTOSEAFLOOR = 8; RELATIVETOSEAFLOOR = 16; \n No altitude : NONE = 0;");
    }

    public String getJavaStaticMethod() {
        return "toKml";
    }

    public static String toKml(Geometry geometry) throws SQLException {
        StringBuilder sb = new StringBuilder();
        KMLGeometry.toKMLGeometry(geometry, sb);
        return sb.toString();
    }

    public static String toKml(Geometry geometry, boolean extrude, int altitudeModeEnum) throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (extrude) {
            KMLGeometry.toKMLGeometry(geometry, ExtrudeMode.TRUE, altitudeModeEnum, sb);
        } else {
            KMLGeometry.toKMLGeometry(geometry, ExtrudeMode.FALSE, altitudeModeEnum, sb);
        }
        return sb.toString();
    }
}

