/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class GpxPreparser
extends DefaultHandler {
    private int totalWpt = 0;
    private int totalRte = 0;
    private int totalRtept = 0;
    private int totalTrk = 0;
    private int totalTrkseg = 0;
    private int totalTrkpt = 0;
    private String version = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(File inputFile) throws SAXException, IOException {
        boolean success = false;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(inputFile);
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setErrorHandler(this);
            parser.setContentHandler(this);
            parser.parse(new InputSource(fs));
            success = true;
        }
        finally {
            if (fs != null) {
                fs.close();
            }
        }
        return success;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.compareToIgnoreCase(GPXTags.GPX) == 0) {
            this.version = attributes.getValue(GPXTags.VERSION);
        } else if (localName.compareToIgnoreCase(GPXTags.RTE) == 0) {
            ++this.totalRte;
        } else if (localName.compareToIgnoreCase(GPXTags.TRK) == 0) {
            ++this.totalTrk;
        } else if (localName.compareToIgnoreCase(GPXTags.TRKSEG) == 0) {
            ++this.totalTrkseg;
        } else if (localName.compareToIgnoreCase(GPXTags.WPT) == 0) {
            ++this.totalWpt;
        } else if (localName.compareToIgnoreCase(GPXTags.RTEPT) == 0) {
            ++this.totalRtept;
        } else if (localName.compareToIgnoreCase(GPXTags.TRKPT) == 0) {
            ++this.totalTrkpt;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public int getTotalWpt() {
        return this.totalWpt;
    }

    public int getTotalRte() {
        return this.totalRte;
    }

    public int getTotalRtept() {
        return this.totalRtept;
    }

    public int getTotalTrk() {
        return this.totalTrk;
    }

    public int getTotalTrkseg() {
        return this.totalTrkseg;
    }

    public int getTotalTrkpt() {
        return this.totalTrkpt;
    }
}

