/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.gpx.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.h2gis.functions.io.gpx.model.AbstractGpxParser;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserRte;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserTrk;
import org.h2gis.functions.io.gpx.model.AbstractGpxParserWpt;
import org.h2gis.functions.io.gpx.model.GPXTablesFactory;
import org.h2gis.functions.io.gpx.model.GPXTags;
import org.h2gis.functions.io.gpx.model.GpxPreparser;
import org.h2gis.functions.io.gpx.model.StringStack;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractGpxParserDefault
extends AbstractGpxParser {
    String WAYPOINT = "_waypoint";
    String ROUTE = "_route";
    String ROUTEPOINT = "_routepoint";
    String TRACK = "_track";
    String TRACKSEGMENT = "_tracksegment";
    String TRACKPOINT = "_trackpoint";
    private AbstractGpxParserWpt wptParser;
    private AbstractGpxParserRte rteParser;
    private AbstractGpxParserTrk trkParser;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;
    private String creator;
    private String version;
    private String name;
    private String desc;
    private String link;
    private String linkText;
    private String time;
    private String authorName;
    private String email;
    private String authorLink;
    private String authorLinkText;
    private String keywords;
    public static final int STRINGSTACK_SIZE = 50;

    public void clear() {
        this.setElementNames(new StringStack(50));
        this.setContentBuffer(new StringBuilder());
        this.setSpecificElement(false);
        this.minLat = 0.0;
        this.maxLat = 0.0;
        this.minLon = 0.0;
        this.maxLon = 0.0;
        this.creator = null;
        this.version = null;
        this.name = null;
        this.desc = null;
        this.link = null;
        this.linkText = null;
        this.time = null;
        this.authorName = null;
        this.email = null;
        this.authorLink = null;
        this.authorLinkText = null;
        this.keywords = null;
    }

    abstract String getCopyright();

    private static String caseIdentifier(TableLocation requestedTable, String tableName, boolean isH2) {
        return new TableLocation(requestedTable.getCatalog(), requestedTable.getSchema(), TableLocation.parse((String)tableName, (Boolean)isH2).getTable()).toString();
    }

    public boolean read(File inputFile, String tableName, Connection connection) throws SQLException {
        boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
        boolean success = false;
        TableLocation requestedTable = TableLocation.parse((String)tableName, (Boolean)isH2);
        String table = requestedTable.getTable();
        this.clear();
        GpxPreparser gpxPreparser = new GpxPreparser();
        try {
            gpxPreparser.read(inputFile);
        }
        catch (SAXException ex) {
            throw new SQLException(ex);
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        StringBuilder tableNames = new StringBuilder();
        if (gpxPreparser.getTotalWpt() > 0) {
            String wptTableName = AbstractGpxParserDefault.caseIdentifier(requestedTable, table + this.WAYPOINT, isH2);
            if (JDBCUtilities.tableExists((Connection)connection, (String)wptTableName)) {
                throw new SQLException("The table " + wptTableName + " already exists.");
            }
            this.setWptPreparedStmt(GPXTablesFactory.createWayPointsTable(connection, wptTableName, isH2));
            tableNames.append(wptTableName).append(",");
        }
        if (gpxPreparser.getTotalRte() > 0 && gpxPreparser.getTotalRtept() > 0) {
            String routeTableName = AbstractGpxParserDefault.caseIdentifier(requestedTable, table + this.ROUTE, isH2);
            if (JDBCUtilities.tableExists((Connection)connection, (String)routeTableName)) {
                throw new SQLException("The table " + routeTableName + " already exists.");
            }
            String routePointsTableName = AbstractGpxParserDefault.caseIdentifier(requestedTable, table + this.ROUTEPOINT, isH2);
            if (JDBCUtilities.tableExists((Connection)connection, (String)routePointsTableName)) {
                throw new SQLException("The table " + routePointsTableName + " already exists.");
            }
            this.setRtePreparedStmt(GPXTablesFactory.createRouteTable(connection, routeTableName, isH2));
            this.setRteptPreparedStmt(GPXTablesFactory.createRoutePointsTable(connection, routePointsTableName, isH2));
            tableNames.append(routeTableName).append(",").append(routePointsTableName).append(",");
        }
        if (gpxPreparser.getTotalTrk() > 0 && gpxPreparser.getTotalTrkseg() > 0 && gpxPreparser.getTotalTrkpt() > 0) {
            String trackTableName = AbstractGpxParserDefault.caseIdentifier(requestedTable, table + this.TRACK, isH2);
            if (JDBCUtilities.tableExists((Connection)connection, (String)trackTableName)) {
                throw new SQLException("The table " + trackTableName + " already exists.");
            }
            String trackSegmentsTableName = AbstractGpxParserDefault.caseIdentifier(requestedTable, table + this.TRACKSEGMENT, isH2);
            if (JDBCUtilities.tableExists((Connection)connection, (String)trackSegmentsTableName)) {
                throw new SQLException("The table " + trackSegmentsTableName + " already exists.");
            }
            String trackPointsTableName = AbstractGpxParserDefault.caseIdentifier(requestedTable, table + this.TRACKPOINT, isH2);
            if (JDBCUtilities.tableExists((Connection)connection, (String)trackPointsTableName)) {
                throw new SQLException("The table " + trackPointsTableName + " already exists.");
            }
            this.setTrkPreparedStmt(GPXTablesFactory.createTrackTable(connection, trackTableName, isH2));
            this.setTrkSegmentsPreparedStmt(GPXTablesFactory.createTrackSegmentsTable(connection, trackSegmentsTableName, isH2));
            this.setTrkPointsPreparedStmt(GPXTablesFactory.createTrackPointsTable(connection, trackPointsTableName, isH2));
            tableNames.append(trackTableName).append(",").append(trackSegmentsTableName).append(",").append(trackPointsTableName).append(",");
        }
        try {
            this.setReader(XMLReaderFactory.createXMLReader());
            this.getReader().setErrorHandler(this);
            this.getReader().setContentHandler(this);
            this.getReader().parse(new InputSource(new FileInputStream(inputFile)));
            success = true;
        }
        catch (SAXException ex) {
            throw new SQLException(ex);
        }
        catch (IOException ex) {
            throw new SQLException("Cannot parse the file " + inputFile.getAbsolutePath(), ex);
        }
        finally {
            if (this.getWptPreparedStmt() != null) {
                this.getWptPreparedStmt().close();
            }
            if (this.getRteptPreparedStmt() != null) {
                this.getRtePreparedStmt().close();
                this.getRteptPreparedStmt().close();
            }
            if (this.getTrkPointsPreparedStmt() != null) {
                this.getTrkPreparedStmt().close();
                this.getTrkSegmentsPreparedStmt().close();
                this.getTrkPointsPreparedStmt().close();
            }
        }
        return success;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.compareToIgnoreCase(GPXTags.GPX) == 0) {
            this.version = attributes.getValue(GPXTags.VERSION);
            this.creator = attributes.getValue(GPXTags.CREATOR);
        } else if (localName.compareToIgnoreCase(GPXTags.BOUNDS) == 0) {
            this.minLat = Double.parseDouble(attributes.getValue(GPXTags.MINLAT));
            this.maxLat = Double.parseDouble(attributes.getValue(GPXTags.MAXLAT));
            this.minLon = Double.parseDouble(attributes.getValue(GPXTags.MINLON));
            this.maxLon = Double.parseDouble(attributes.getValue(GPXTags.MAXLON));
        }
        this.getContentBuffer().delete(0, this.getContentBuffer().length());
        this.getElementNames().push(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.setCurrentElement(this.getElementNames().pop());
        if (this.getCurrentElement().equalsIgnoreCase(GPXTags.WPT)) {
            this.setSpecificElement(false);
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.RTE)) {
            this.setSpecificElement(false);
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.TRK)) {
            this.setSpecificElement(false);
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.TIME) && !this.isSpecificElement()) {
            this.time = this.getContentBuffer().toString();
        } else if (this.getCurrentElement().equalsIgnoreCase(GPXTags.DESC) && !this.isSpecificElement()) {
            this.desc = this.getContentBuffer().toString();
        } else if (localName.equalsIgnoreCase(GPXTags.KEYWORDS)) {
            this.keywords = this.getContentBuffer().toString();
        }
    }

    public String getTime() {
        return this.time;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCreator() {
        return this.creator;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getFullLink() {
        return "Link : " + this.link + "\nText of hyperlink : " + this.linkText;
    }

    public String getFullAuthor() {
        return "Author : " + this.authorName + "\nEmail : " + this.email + "\nLink : " + this.authorLink + "\nText : " + this.authorLinkText;
    }

    public void setAuthorLink(String authorLink) {
        this.authorLink = authorLink;
    }

    public void setAuthorLinkText(String authorLinkText) {
        this.authorLinkText = authorLinkText;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractGpxParserWpt getWptParser() {
        return this.wptParser;
    }

    public void setWptParser(AbstractGpxParserWpt wptParser) {
        this.wptParser = wptParser;
    }

    public void setRteParser(AbstractGpxParserRte rteParser) {
        this.rteParser = rteParser;
    }

    public AbstractGpxParserRte getRteParser() {
        return this.rteParser;
    }

    public void setTrkParser(AbstractGpxParserTrk trkParser) {
        this.trkParser = trkParser;
    }

    public AbstractGpxParserTrk getTrkParser() {
        return this.trkParser;
    }
}

