/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.file_table;

import java.io.IOException;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueLong;
import org.h2gis.functions.io.FileDriver;

public class H2TableIndex
extends BaseIndex {
    public static final String PK_COLUMN_NAME = "PK";
    private FileDriver driver;
    private final boolean isScanIndex;

    public H2TableIndex(FileDriver driver, Table table, int id) {
        this.isScanIndex = true;
        this.driver = driver;
        IndexColumn indexColumn = new IndexColumn();
        indexColumn.columnName = "key";
        indexColumn.column = new Column("key", 5);
        this.initBaseIndex(table, id, table.getName() + "_ROWID_", new IndexColumn[]{indexColumn}, IndexType.createScan((boolean)true));
    }

    public H2TableIndex(FileDriver driver, Table table, int id, Column PKColumn, String indexName) {
        this.isScanIndex = false;
        this.driver = driver;
        IndexColumn indexColumn = new IndexColumn();
        indexColumn.columnName = PK_COLUMN_NAME;
        indexColumn.column = PKColumn;
        indexColumn.sortType = 0;
        this.initBaseIndex(table, id, indexName, new IndexColumn[]{indexColumn}, IndexType.createPrimaryKey((boolean)true, (boolean)false));
    }

    public void checkRename() {
    }

    public FileDriver getDriver() {
        return this.driver;
    }

    public Row getRow(Session session, long key) {
        try {
            Object[] driverRow = this.driver.getRow(key - 1L);
            Value[] values = new Value[driverRow.length + 1];
            Column[] columns = this.table.getColumns();
            values[0] = ValueLong.get((long)key);
            for (int idField = 1; idField <= driverRow.length; ++idField) {
                values[idField] = DataType.convertToValue((SessionInterface)session, (Object)driverRow[idField - 1], (int)columns[idField - 1].getType());
            }
            Row row = new Row(values, -1);
            row.setKey(key);
            return row;
        }
        catch (IOException ex) {
            throw DbException.get((int)90028, (Throwable)ex, (String[])new String[0]);
        }
    }

    public void close(Session session) {
    }

    public void add(Session session, Row row) {
    }

    public void remove(Session session, Row row) {
        throw DbException.get((int)50100, (String)"remove in Shape files");
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (!this.isScanIndex) {
            Row remakefirst = new Row(null, 0);
            if (first != null) {
                remakefirst.setKey(first.getValue(0).getLong());
            } else {
                remakefirst.setKey(1L);
            }
            Row remakeLast = new Row(null, 0);
            if (last != null) {
                remakeLast.setKey(last.getValue(0).getLong());
            } else {
                remakeLast.setKey(this.getRowCount(session));
            }
            first = remakefirst;
            last = remakeLast;
        }
        return new SHPCursor(this, first, last, session);
    }

    public boolean canScan() {
        return true;
    }

    public boolean canFindNext() {
        return true;
    }

    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        if (masks == null) {
            return Double.MAX_VALUE;
        }
        for (Column column : this.columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1 || (mask & 2) == 2 || (mask & 4) == 4 || (mask & 6) == 6) continue;
            return Double.MAX_VALUE;
        }
        return 2.0;
    }

    public void remove(Session session) {
        throw DbException.get((int)50100, (String)"remove in Shape files");
    }

    public void truncate(Session session) {
        throw DbException.get((int)50100, (String)"truncate in Shape files");
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean first) {
        return new SHPCursor(this, first ? 0L : this.getRowCount(session), session);
    }

    public boolean needRebuild() {
        return false;
    }

    public long getRowCount(Session session) {
        return this.driver.getRowCount();
    }

    public long getRowCountApproximation() {
        return this.driver.getRowCount();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public boolean isRowIdIndex() {
        return this.isScanIndex;
    }

    private static class SHPCursor
    implements Cursor {
        private H2TableIndex tIndex;
        private long rowIndex;
        private Session session;
        private SearchRow begin;
        private SearchRow end;

        private SHPCursor(H2TableIndex tIndex, long rowIndex, Session session) {
            this.tIndex = tIndex;
            this.rowIndex = rowIndex;
            this.session = session;
        }

        private SHPCursor(H2TableIndex tIndex, SearchRow begin, SearchRow end, Session session) {
            this.tIndex = tIndex;
            this.session = session;
            this.begin = begin;
            this.end = end;
            this.rowIndex = begin == null ? 0L : begin.getKey() - 1L;
        }

        public Row get() {
            return this.tIndex.getRow(this.session, this.rowIndex);
        }

        public SearchRow getSearchRow() {
            Row row = new Row(new Value[this.tIndex.getTable().getColumns().length], -1);
            row.setKey(this.rowIndex);
            for (IndexColumn column : this.tIndex.getIndexColumns()) {
                if (column.column.getColumnId() < 0) continue;
                row.setValue(column.column.getColumnId(), (Value)ValueLong.get((long)this.rowIndex));
            }
            return row;
        }

        public boolean next() {
            if (this.rowIndex < this.tIndex.getRowCount(this.session) && (this.end == null || this.rowIndex < this.end.getKey())) {
                ++this.rowIndex;
                return true;
            }
            return false;
        }

        public boolean previous() {
            if (this.rowIndex > 0L && (this.begin == null || this.rowIndex >= this.begin.getKey())) {
                --this.rowIndex;
                return true;
            }
            return false;
        }
    }
}

