/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.devui;

import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;
import org.optaplanner.quarkus.devui.OptaPlannerDevUIProperties;
import org.optaplanner.quarkus.devui.OptaPlannerModelProperties;

public class OptaPlannerDevUIPropertiesSupplier
implements Supplier<OptaPlannerDevUIProperties> {
    private String effectiveSolverConfigXml;

    public OptaPlannerDevUIPropertiesSupplier() {
        this.effectiveSolverConfigXml = null;
    }

    public OptaPlannerDevUIPropertiesSupplier(String effectiveSolverConfigXml) {
        this.effectiveSolverConfigXml = effectiveSolverConfigXml;
    }

    public String getEffectiveSolverConfigXml() {
        return this.effectiveSolverConfigXml;
    }

    public void setEffectiveSolverConfigXml(String effectiveSolverConfigXml) {
        this.effectiveSolverConfigXml = effectiveSolverConfigXml;
    }

    @Override
    public OptaPlannerDevUIProperties get() {
        if (this.effectiveSolverConfigXml != null) {
            return new OptaPlannerDevUIProperties(this.getModelInfo(), this.getXmlContentWithComment("Properties that can be set at runtime are not included"), this.getConstraintList());
        }
        return new OptaPlannerDevUIProperties(this.getModelInfo(), "<!-- Plugin execution was skipped because there are no @" + PlanningSolution.class.getSimpleName() + " or @" + PlanningEntity.class.getSimpleName() + " annotated classes. -->\n<solver />", Collections.emptyList());
    }

    private OptaPlannerModelProperties getModelInfo() {
        if (this.effectiveSolverConfigXml != null) {
            DefaultSolverFactory solverFactory = (DefaultSolverFactory)Arc.container().instance(SolverFactory.class, new Annotation[0]).get();
            SolutionDescriptor solutionDescriptor = solverFactory.getScoreDirectorFactory().getSolutionDescriptor();
            OptaPlannerModelProperties out = new OptaPlannerModelProperties();
            out.setSolutionClass(solutionDescriptor.getSolutionClass().getName());
            ArrayList<String> entityClassList = new ArrayList<String>();
            HashMap<String, List<String>> entityClassToGenuineVariableListMap = new HashMap<String, List<String>>();
            HashMap<String, List<String>> entityClassToShadowVariableListMap = new HashMap<String, List<String>>();
            for (EntityDescriptor entityDescriptor : solutionDescriptor.getEntityDescriptors()) {
                entityClassList.add(entityDescriptor.getEntityClass().getName());
                ArrayList<String> entityClassToGenuineVariableList = new ArrayList<String>();
                ArrayList<String> entityClassToShadowVariableList = new ArrayList<String>();
                for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                    if (variableDescriptor instanceof GenuineVariableDescriptor) {
                        entityClassToGenuineVariableList.add(variableDescriptor.getVariableName());
                        continue;
                    }
                    entityClassToShadowVariableList.add(variableDescriptor.getVariableName());
                }
                entityClassToGenuineVariableListMap.put(entityDescriptor.getEntityClass().getName(), entityClassToGenuineVariableList);
                entityClassToShadowVariableListMap.put(entityDescriptor.getEntityClass().getName(), entityClassToShadowVariableList);
            }
            out.setEntityClassList(entityClassList);
            out.setEntityClassToGenuineVariableListMap(entityClassToGenuineVariableListMap);
            out.setEntityClassToShadowVariableListMap(entityClassToShadowVariableListMap);
            return out;
        }
        return new OptaPlannerModelProperties();
    }

    private List<String> getConstraintList() {
        DefaultSolverFactory solverFactory;
        if (this.effectiveSolverConfigXml != null && (solverFactory = (DefaultSolverFactory)Arc.container().instance(SolverFactory.class, new Annotation[0]).get()).getScoreDirectorFactory() instanceof AbstractConstraintStreamScoreDirectorFactory) {
            AbstractConstraintStreamScoreDirectorFactory scoreDirectorFactory = (AbstractConstraintStreamScoreDirectorFactory)solverFactory.getScoreDirectorFactory();
            return Arrays.stream(scoreDirectorFactory.getConstraints()).map(Constraint::getConstraintId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String getXmlContentWithComment(String comment) {
        int indexOfPreambleEnd = this.effectiveSolverConfigXml.indexOf("?>");
        if (indexOfPreambleEnd != -1) {
            return this.effectiveSolverConfigXml.substring(0, indexOfPreambleEnd + 2) + "\n<!--" + comment + "-->\n" + this.effectiveSolverConfigXml.substring(indexOfPreambleEnd + 2);
        }
        return "<!--" + comment + "-->\n" + this.effectiveSolverConfigXml;
    }
}

