/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.jsp.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JasperClassLoader
extends URLClassLoader {
    private final BundleClassLoader m_bundleClassLoader;
    private static final Logger LOG = LoggerFactory.getLogger(JasperClassLoader.class);
    private static final String bundleClassLoaderClassName = "org.ops4j.pax.swissbox.core.BundleClassLoader";
    private static final String osgiBundleClassName = "org.osgi.framework.Bundle";

    public JasperClassLoader(Bundle bundle, ClassLoader parent) {
        super(ClassPathUtil.getClassPathJars((Bundle)bundle));
        this.m_bundleClassLoader = new BundleClassLoader(bundle, parent);
    }

    @Override
    public URL getResource(String name) {
        return this.m_bundleClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.m_bundleClassLoader.getResources(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.m_bundleClassLoader.loadClass(name);
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("bundleClassLoader=").append(this.m_bundleClassLoader).append("}").toString();
    }

    @Override
    public URL[] getURLs() {
        return super.getURLs();
    }

    public boolean equals(Object o) {
        LOG.trace("JasperClassLoader.equals() invoked");
        if (this == o) {
            LOG.trace("JasperClassLoader.equals(): same object");
            return true;
        }
        if (o == null) {
            LOG.trace("JasperClassLoader.equals(): testing equality against null object");
            return false;
        }
        if (!o.getClass().getCanonicalName().equals(bundleClassLoaderClassName)) {
            LOG.trace("JasperClassLoader.equals(): testing equality against another JasperClassLoader object");
            return super.equals(o);
        }
        LOG.trace("JasperClassLoader.equals(): testing equality against a BundleClassLoader object");
        long myBundleId = -1L;
        long theirBundleId = -2L;
        try {
            myBundleId = this.m_bundleClassLoader.getBundle().getBundleId();
            Class<?> bundleClassLoaderClass = o.getClass().getClassLoader().loadClass(bundleClassLoaderClassName);
            Object bundle = bundleClassLoaderClass.getMethod("getBundle", new Class[0]).invoke(o, null);
            Class<?> bundleClass = o.getClass().getClassLoader().loadClass(osgiBundleClassName);
            theirBundleId = (Long)bundleClass.getMethod("getBundleId", new Class[0]).invoke(bundle, null);
        }
        catch (Exception e) {
            LOG.error("Unable to evaluate equality of JasperClassLoader object against BundleClassLoader object", (Throwable)e);
        }
        return myBundleId == theirBundleId;
    }

    public int hashCode() {
        LOG.trace("Using m_bundleClassloader.hashCode()");
        if (this.m_bundleClassLoader == null) {
            return super.hashCode();
        }
        Bundle bundle = this.m_bundleClassLoader.getBundle();
        int hash = bundle != null ? bundle.hashCode() * 37 : this.m_bundleClassLoader.hashCode();
        LOG.trace("m_bundleClassloader.hashCode() result: " + hash);
        return hash;
    }

    public List<URL> scanBundlesInClassSpace(String directory, String filePattern, boolean recursive) {
        Set bundlesInClassSpace = ClassPathUtil.getBundlesInClassSpace((Bundle)this.m_bundleClassLoader.getBundle(), new HashSet());
        ArrayList<URL> matching = new ArrayList<URL>();
        for (Bundle bundle : bundlesInClassSpace) {
            Enumeration e = bundle.findEntries(directory, filePattern, recursive);
            if (e == null) continue;
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                matching.add(u);
            }
        }
        return matching;
    }
}

