/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.jsp;

import java.io.IOException;
import java.util.concurrent.Callable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.jasper.servlet.JspServlet;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.web.jsp.internal.JasperClassLoader;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspServletWrapper
implements Servlet {
    private static final Logger LOG = LoggerFactory.getLogger(JspServletWrapper.class);
    private final JspServlet m_jasperServlet = new JspServlet();
    private final JasperClassLoader m_jasperClassLoader;
    private final String jspFile;

    public JspServletWrapper(Bundle bundle, String jspFile) {
        this.m_jasperClassLoader = new JasperClassLoader(bundle, JasperClassLoader.class.getClassLoader());
        this.jspFile = jspFile;
    }

    public JspServletWrapper(Bundle bundle) {
        this(bundle, null);
    }

    public void init(final ServletConfig config) throws ServletException {
        try {
            ContextClassLoaderUtils.doWithClassLoader(this.m_jasperClassLoader, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    JspServletWrapper.this.m_jasperServlet.init(config);
                    return null;
                }
            });
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ignore) {
            LOG.error("Ignored exception", (Throwable)ignore);
        }
    }

    public ServletConfig getServletConfig() {
        return this.m_jasperServlet.getServletConfig();
    }

    public void service(final ServletRequest req, final ServletResponse res) throws ServletException, IOException {
        if (this.jspFile != null) {
            req.setAttribute("org.apache.catalina.jsp_file", (Object)this.jspFile);
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(this.m_jasperClassLoader, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    JspServletWrapper.this.m_jasperServlet.service(req, res);
                    return null;
                }
            });
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ignore) {
            LOG.error("Ignored exception", (Throwable)ignore);
        }
    }

    public String getServletInfo() {
        return this.m_jasperServlet.getServletInfo();
    }

    public void destroy() {
        try {
            ContextClassLoaderUtils.doWithClassLoader(this.m_jasperClassLoader, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    JspServletWrapper.this.m_jasperServlet.destroy();
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ignore) {
            LOG.error("Ignored exception", (Throwable)ignore);
        }
    }
}

