/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import org.ops4j.pax.url.mvn.internal.AetherBasedResolver;
import org.ops4j.pax.url.mvn.internal.Parser;
import org.ops4j.pax.url.mvn.internal.config.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.config.MavenConfigurationImpl;
import org.ops4j.pax.url.mvn.internal.config.MavenRepositoryURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.ops4j.lang.NullArgumentException;

public class Connection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    private Parser m_parser;
    private AetherBasedResolver m_aetherBasedResolver;

    public Connection(URL url, MavenConfiguration configuration) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL cannot be null");
        NullArgumentException.validateNotNull(configuration, "Service configuration");
        this.m_parser = new Parser(url.getPath());
        MavenRepositoryURL repoUrl = this.m_parser.getRepositoryURL();
        if (repoUrl != null) {
            MavenConfigurationImpl config = (MavenConfigurationImpl)configuration;
            config.set("org.ops4j.pax.url.mvn.repositories", Arrays.asList(repoUrl));
        }
        this.m_aetherBasedResolver = new AetherBasedResolver(configuration);
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        LOG.debug("Resolving [" + this.url.toExternalForm() + "]");
        return this.m_aetherBasedResolver.resolve(this.m_parser.getGroup(), this.m_parser.getArtifact(), this.m_parser.getClassifier(), this.m_parser.getType(), this.m_parser.getVersion());
    }
}

