/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WorkItemCoder.java 3087 2006-08-30 07:08:10Z jmettraux $
 */

//
// WorkItemCoder.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;


/**
 * To be implemented by the classes that will have to turn whatever into
 * a workitem
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 09:08:10 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: WorkItemCoder.java 3087 2006-08-30 07:08:10Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface WorkItemCoder
{

    /**
     * Stuffs the coder with knowledge about en/decoding attributes and
     * listener's replies
     */
    public void init 
        (String name, 
         java.util.List attributeCoders, 
         ListenerReplyCoder replyCoder,
         java.util.Map coderParams);

    /** 
     * Returns the name of this coder.
     */
    public String getName ();

    /**
     * Returns the MIME type to associate with this [en]coder.
     */
    public String getMimeType ();

    /**
     * Turns the workitem into some other class instance.
     */
    public Object encode 
        (WorkItem wi, ApplicationContext context, java.util.Map params)
    throws 
        CodingException;

    /**
     * Transforms something into a workitem
     */
    public WorkItem decode 
        (Object o, ApplicationContext context, java.util.Map params) 
    throws 
        CodingException;

    /**
     * Returns the attribute coder dedicated in this workitemcoder for 
     * the given attribute
     */
    public AttributeCoder getAttributeCoder (Attribute a)
        throws CodingException;

    /**
     * Returns the attribute coder that can handle the given attributeClass
     */
    public AttributeCoder getAttributeCoder (Class attributeClass)
        throws CodingException;

    /**
     * Returns the assorted coder for replies
     */
    public ListenerReplyCoder getReplyCoder ();

}
