/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MapAttribute.java 3343 2006-09-17 10:51:05Z jmettraux $
 */

//
// MapAttribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.util.ReflectionUtils;


/**
 * A dictionary of attributes
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-17 12:51:05 +0200 (Sun, 17 Sep 2006) $
 * <br>$Id: MapAttribute.java 3343 2006-09-17 10:51:05Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MapAttribute

    extends CollectionAttribute

    implements java.util.Map

{

    static final long serialVersionUID = -1843868545451617886L;

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MapAttribute.class.getName());
    */

    //
    // CONSTANTS and co

    /**
     * When someone requests the '__keyset' element of this map,
     * it will receive a ListAttribute containing all the
     * key elements of this map.
     */
    public final static String K_KEYSET
        = "__keyset__";

    //
    // FIELDS

    private java.util.Map map = new java.util.LinkedHashMap();

    //
    // CONSTRUCTORS

    public MapAttribute () 
    {
        super();
    }

    public MapAttribute (int initialCapacity) 
    {
        super();

        this.map = new java.util.LinkedHashMap(initialCapacity);
    }

    //
    // BEAN METHODS

    public java.util.Map getMap () { return this.map; }
    public void setMap (java.util.Map m) { this.map = m; }

    //
    // METHODS

    public java.util.Set keySet () 
    {
        return this.map.keySet();
    }

    public java.util.Collection values ()
    {
        return this.map.values();
    }

    public java.util.Set entrySet ()
    {
        return this.map.entrySet();
    }

    /**
     * You could use this method directly, but aget() and cget() are better.
     */
    public Object get (final Object key)
    {
        if (key instanceof String)
            return cget((String)key);

        return this.map.get(key);
    }

    /**
     * Don't use this method directly, use rather aput.
     */
    public synchronized Object put (final Object key, final Object value)
    {
        return this.map.put
            (AttributeUtils.java2owfe(key),
             AttributeUtils.java2owfe(value));
    }

    public Attribute aget (final Attribute key)
    {
        return (Attribute)this.map.get(key);
    }

    /**
     * The implementation of cget() as defined in the parent
     * class CollectionAttribute.
     */
    public Attribute cget (final String key)
    {
        if (key.equals(K_KEYSET))
            return new ListAttribute(this.map.keySet());

        return (Attribute)this.map.get(new StringAttribute(key));
    }

    public synchronized void aput (final Attribute key, final Attribute value)
    {
        if (value == null) 
            this.map.remove(key);
        else
            this.map.put(key, value);
    }

    /**
     * The object key is meant to an instance of Attribute.
     */
    public synchronized Object remove (final Object key)
    {
        return this.map.remove(key);
    }

    public int size ()
    {
        return this.map.size();
    }

    public int hashCode ()
    {
        return this.map.hashCode();
    }

    public synchronized Object clone ()
    {
        final MapAttribute clone = 
            (MapAttribute)ReflectionUtils.newInstance(this);

        java.util.Iterator it = this.map.keySet().iterator();
        while (it.hasNext())
        {
            Attribute key = (Attribute)it.next();
            Attribute value = this.aget(key);

            //clone.put((Attribute)key.clone(), (Attribute)value.clone());
            
            //if (key != null)
            clone.put((Attribute)key.clone(), clone(value));
        }

        return clone;
    }

    private Attribute clone (final Attribute a)
    {
        if (a == null) return null;
        return (Attribute)a.clone();
    }

    /**
     * Adds the content of a given map attribute to this map attribute.
     */
    public synchronized void putAll (final java.util.Map m)
    {
        if (m instanceof MapAttribute)
            this.map.putAll(((MapAttribute)m).map);
        else
            this.map.putAll(AttributeUtils.map2owfe(m));
    }

    /**
     * The equivalent of put(new StringAttribute(key), value). But this
     * is mainly a method required by CollectionAttribute, the parent class.
     * This method is used by setField in CollectionAttribute,
     * it has thus an internal value rather than an API value.
     */
    public void cput (final String key, final Attribute value)
    {
        this.put(new StringAttribute(key), value);
    }

    public boolean containsValue (final Object o)
    {
        return this.map.containsValue(o);
    }

    public boolean containsKey (final Object o)
    {
        return this.map.containsKey(o);
    }

    public boolean isEmpty ()
    {
        return this.map.isEmpty();
    }

    public synchronized void clear ()
    {
        this.map.clear();
    }

    //
    // STATIC METHODS

}
