/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ListAttribute.java 3334 2006-09-17 06:19:18Z jmettraux $
 */

//
// ListAttribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

/**
 * A list (array) of attributes.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-17 08:19:18 +0200 (Sun, 17 Sep 2006) $
 * <br>$Id: ListAttribute.java 3334 2006-09-17 06:19:18Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ListAttribute

    extends CollectionAttribute

    implements java.util.Collection

{

    static final long serialVersionUID = -4477732509573801752L;


    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ListAttribute.class.getName());

    //
    // FIELDS

    //protected java.util.ArrayList list = null;
    private java.util.List list = null;

    //
    // CONSTRUCTORS

    public ListAttribute ()
    {
        super();

        this.list = new java.util.LinkedList();
    }

    public ListAttribute (final int initialSize)
    {
        super();

        this.list = new java.util.ArrayList(initialSize);
    }

    public ListAttribute (final java.util.Collection c)
    {
        super();
        
        this.list = new java.util.ArrayList(c);
    }

    //
    // BEAN METHODS

    public java.util.List getList () { return this.list; }
    public void setList (final java.util.List l) { this.list = l; }

    //
    // METHODS

    public synchronized void ladd (final Attribute a)
    {
        this.list.add(a);
    }

    public synchronized void ladd (final int index, final Attribute a)
    {
        this.list.add(index, a);
    }

    public int indexOf (final Attribute a)
    {
        return this.list.indexOf(a);
    }

    public Attribute get (final int index)
    {
        //log.debug("get() i = "+index);

        int i = index;

        if (i < 0) i = this.list.size() + i;

        //log.debug("get() i = "+i);

        if (i >= this.list.size()) return null;

        return (Attribute)this.list.get(i);
    }

    /**
     * Meant for cget("3") or cget("0"). If the key doesn't parse to an
     * integer, null will be returned.
     */
    public Attribute cget (final String key)
    {
        if (key == null) return null;

        //
        // is it a 'range get' ?

        final int icolon = key.indexOf(":");

        if (icolon > -1)
        {
            if (icolon != key.lastIndexOf(":")) return null;

            try
            {
                final ListAttribute la = new ListAttribute();
                
                final String[] ss = key.split(":");

                final int start = Integer.parseInt(ss[0]);
                final int end = Integer.parseInt(ss[1]);

                int inc = 1; 
                if (end < start) inc = -1;

                for (int i = start; ; i = i + inc)
                {
                    if (i > end && inc > 0) break;
                    if (i < end && inc < 0) break;

                    final Attribute a = get(i);

                    if (a != null) la.add(a);
                }

                return la;
            }
            catch (final Throwable t)
            {
                log.debug("get() failure", t);

                // ignore and return null
            }
            return null;
        }

        //
        // 'set of indexes' get ?

        if (key.indexOf(",") > -1)
        {
            final String[] ss = key.split(",");

            final ListAttribute la = new ListAttribute();

            for (int i=0; i<ss.length; i++)
            {
                try
                {
                    la.add(this.get(Integer.parseInt(ss[i])));
                }
                catch (final Throwable t)
                {
                    // ignore : nothing gets thus added
                }
            }

            return la;
        }

        //
        // regular (one index) get

        try
        {
            return get(Integer.parseInt(key));
        }
        catch (final Throwable t)
        {
            // meant for intercepting NumberFormatExceptions
            // and ArrayIndexOutOfBoundExceptions.
        }
        return null;
    }

    /**
     * This method is used by setField in CollectionAttribute,
     * it has thus an internal value rather than an API value.
     */
    public synchronized void cput (final String key, final Attribute value)
    {
        try
        {
            final int i = Integer.parseInt(key);

            if (value == null)
                this.list.remove(i);
            else
                this.list.set(i, value);
        }
        catch (final Throwable t)
        {
            if (value == null)
                log.warn("cput() failed to remove key '"+key+"'", t);
            else
                log.warn("cput() failed to set key '"+key+"'", t);
        }
    }

    /**
     * The object key is meant to an instance of Attribute.
     */
    public synchronized boolean remove (final Object o)
    {
        return this.list.remove(o);
    }

    public int size ()
    {
        return this.list.size();
    }

    public java.util.Iterator iterator ()
    {
        return this.list.iterator();
    }

    public synchronized void clear ()
    {
        this.list.clear();
    }

    public int hashCode ()
    {
        return this.list.hashCode();
    }

    public synchronized Object clone ()
    {
        ListAttribute clone = new ListAttribute(this.size());

        java.util.Iterator it = this.list.iterator();
        while (it.hasNext())
        {
            Attribute a = (Attribute)it.next();
            clone.add((Attribute)a.clone());
        }

        return clone;
    }

    /**
     * Returns a String of the contained values, separated by commas.
     */
    public String toString ()
    {
        final StringBuffer sb = new StringBuffer();

        //sb.append("[ ");

        final java.util.Iterator it = this.iterator();
        while (it.hasNext())
        {
            sb.append(it.next().toString());

            if (it.hasNext()) sb.append(", ");
        }

        //sb.append(" ]");

        return sb.toString();
    }

    //
    // METHODS from java.util.Collection

    /**
     * Calls the method with the same name on the underlying list.
     */
    public Object[] toArray ()
    {
        return this.list.toArray();
    }

    /**
     * Calls the method with the same name on the underlying list.
     */
    public Object[] toArray (final Object[] a)
    {
        return this.list.toArray(a);
    }

    /**
     * Calls the method with the same name on the underlying list.
     */
    public boolean retainAll (final java.util.Collection c)
    {
        return this.list.retainAll(c);
    }

    /**
     * Calls the method with the same name on the underlying list.
     */
    public synchronized boolean removeAll (final java.util.Collection c)
    {
        return this.list.removeAll(c);
    }

    /**
     * Calls the method with the same name on the underlying list.
     */
    public boolean containsAll (final java.util.Collection c)
    {
        return this.list.containsAll(c);
    }

    /**
     * Calls the method with the same name on the underlying list.
     */
    public synchronized boolean addAll (final java.util.Collection c)
    {
        return this.list.addAll(c);
    }

    /**
     * Calls the method with the same name on the underlying list.
     */
    public boolean contains (final Object o)
    {
        return this.list.contains(o);
    }

    /**
     * Calls the method with the same name on the underlying list.
     */
    public synchronized boolean add (final Object o)
    {
        return this.list.add(o);
    }

    /**
     * Calls the method with the same name on the underlying list.
     */
    public boolean isEmpty ()
    {
        return this.list.isEmpty();
    }

}
